/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.appdeployer.export.impl;

import com.marklogic.appdeployer.export.ExportedResources;
import com.marklogic.appdeployer.export.ResourceExporter;
import com.marklogic.appdeployer.export.impl.AbstractResourceExporter;
import com.marklogic.client.ext.helper.LoggingObject;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class CompositeResourceExporter
extends LoggingObject
implements ResourceExporter {
    private List<ResourceExporter> resourceExporters = new ArrayList<ResourceExporter>();
    private boolean overrideFormatOnExporters = true;
    private String format = "json";

    public CompositeResourceExporter(ResourceExporter ... resourceExporters) {
        for (ResourceExporter exporter : resourceExporters) {
            this.resourceExporters.add(exporter);
        }
    }

    public void add(ResourceExporter exporter) {
        this.resourceExporters.add(exporter);
    }

    @Override
    public ExportedResources exportResources(File baseDir) {
        ExportedResources resources = null;
        for (ResourceExporter exporter : this.resourceExporters) {
            if (this.overrideFormatOnExporters && exporter instanceof AbstractResourceExporter) {
                ((AbstractResourceExporter)exporter).setFormat(this.getFormat());
            }
            ExportedResources er = exporter.exportResources(baseDir);
            if (resources == null) {
                resources = er;
                continue;
            }
            resources.add(er);
        }
        if (resources == null) {
            resources = new ExportedResources(new ArrayList<File>(), new String[0]);
        }
        return resources;
    }

    public boolean isOverrideFormatOnExporters() {
        return this.overrideFormatOnExporters;
    }

    public void setOverrideFormatOnExporters(boolean overrideFormatOnExporters) {
        this.overrideFormatOnExporters = overrideFormatOnExporters;
    }

    public List<ResourceExporter> getResourceExporters() {
        return this.resourceExporters;
    }

    public void setResourceExporters(List<ResourceExporter> resourceExporters) {
        this.resourceExporters = resourceExporters;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }
}

