/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.appdeployer.command.tasks;

import com.marklogic.appdeployer.ConfigDir;
import com.marklogic.appdeployer.command.AbstractResourceCommand;
import com.marklogic.appdeployer.command.CommandContext;
import com.marklogic.appdeployer.command.SortOrderConstants;
import com.marklogic.appdeployer.command.tasks.IsDirectoryFilter;
import com.marklogic.mgmt.resource.ResourceManager;
import com.marklogic.mgmt.resource.tasks.TaskManager;
import java.io.File;

public class DeployScheduledTasksCommand
extends AbstractResourceCommand {
    private String groupName;

    public DeployScheduledTasksCommand() {
        this.setExecuteSortOrder(SortOrderConstants.DEPLOY_SCHEDULED_TASKS);
        this.setUndoSortOrder(SortOrderConstants.DELETE_SCHEDULED_TASKS);
    }

    @Override
    protected File[] getResourceDirs(CommandContext context) {
        return this.findResourceDirs(context, (ConfigDir configDir) -> configDir.getTasksDir());
    }

    @Override
    protected ResourceManager getResourceManager(CommandContext context) {
        TaskManager mgr = new TaskManager(context.getManageClient());
        if (this.groupName != null) {
            mgr.setGroupName(this.groupName);
        }
        return mgr;
    }

    @Override
    public void execute(CommandContext context) {
        super.execute(context);
        String originalGroupName = this.groupName;
        for (File resourceDir : this.getResourceDirs(context)) {
            if (resourceDir == null || !resourceDir.isDirectory()) continue;
            for (File dir : resourceDir.listFiles(new IsDirectoryFilter())) {
                this.setGroupName(dir.getName());
                this.processExecuteOnResourceDir(context, dir);
            }
        }
        this.setGroupName(originalGroupName);
    }

    @Override
    public void undo(CommandContext context) {
        super.undo(context);
        String originalGroupName = this.groupName;
        for (File resourceDir : this.getResourceDirs(context)) {
            if (resourceDir == null || !resourceDir.isDirectory()) continue;
            for (File dir : resourceDir.listFiles(new IsDirectoryFilter())) {
                this.setGroupName(dir.getName());
                this.processUndoOnResourceDir(context, dir);
            }
        }
        this.setGroupName(originalGroupName);
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }
}

