/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.appdeployer.command.security;

import com.marklogic.appdeployer.ConfigDir;
import com.marklogic.appdeployer.command.AbstractCommand;
import com.marklogic.appdeployer.command.CommandContext;
import com.marklogic.appdeployer.command.SortOrderConstants;
import com.marklogic.mgmt.resource.security.CertificateTemplateManager;
import java.io.File;
import java.util.List;

public class InsertCertificateHostsTemplateCommand
extends AbstractCommand {
    private String publicCertificateFileExtension = ".crt";
    private String privateKeyFileExtension = ".key";

    public InsertCertificateHostsTemplateCommand() {
        this.setExecuteSortOrder(SortOrderConstants.INSERT_HOST_CERTIFICATES);
    }

    @Override
    public void execute(CommandContext context) {
        List<String> templateNames = new CertificateTemplateManager(context.getManageClient()).getAsXml().getListItemNameRefs();
        if (templateNames != null && !templateNames.isEmpty()) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Looking for host certificates to insert for certificate templates: " + templateNames);
            }
            for (String templateName : templateNames) {
                this.insertHostCertificatesForTemplate(context, templateName);
            }
        }
    }

    protected void insertHostCertificatesForTemplate(CommandContext context, String templateName) {
        for (ConfigDir configDir : context.getAppConfig().getConfigDirs()) {
            File hostCertDir = new File(configDir.getCertificateTemplatesDir() + File.separator + "host-certificates" + File.separator + templateName);
            this.logger.info(this.format("Looking for host certificate files ending in '%s' for template '%s' in: %s", new Object[]{this.publicCertificateFileExtension, templateName, hostCertDir.getAbsolutePath()}));
            if (!hostCertDir.exists()) continue;
            for (File f : hostCertDir.listFiles()) {
                if (!f.getName().endsWith(this.publicCertificateFileExtension)) continue;
                File privateKeyFile = this.determinePrivateKeyFile(f);
                if (privateKeyFile.exists()) {
                    this.logger.info("Found public certificate file at: " + f.getAbsolutePath() + ", and found corresponding private key file at: " + privateKeyFile.getAbsolutePath());
                    this.insertHostCertificate(context, templateName, f, privateKeyFile);
                    continue;
                }
                this.logger.warn("Did not find expected private key file at: " + privateKeyFile.getAbsolutePath() + "; will ignore public certificate file found at: " + f.getAbsolutePath());
            }
        }
    }

    protected File determinePrivateKeyFile(File publicCertificateFile) {
        String path = publicCertificateFile.getAbsolutePath();
        return new File(path.substring(0, path.length() - this.publicCertificateFileExtension.length()) + this.privateKeyFileExtension);
    }

    protected void insertHostCertificate(CommandContext context, String templateName, File publicCertFile, File privateKeyFile) {
        CertificateTemplateManager mgr = new CertificateTemplateManager(context.getManageClient());
        if (!mgr.certificateExists(templateName)) {
            this.logger.info(this.format("Inserting host certificate for certificate template '%s'", new Object[]{templateName}));
            String pubCertString = this.copyFileToString(publicCertFile);
            String privateKeyString = this.copyFileToString(privateKeyFile);
            mgr.insertHostCertificate(templateName, pubCertString, privateKeyString);
            this.logger.info(this.format("Inserted host certificate for certificate template '%s'", new Object[]{templateName}));
        } else {
            this.logger.info(this.format("Host certificate already exists for certificate template '%s', so not inserting host certificate found at: %s", new Object[]{templateName, publicCertFile.getAbsolutePath()}));
        }
    }

    public void setPublicCertificateFileExtension(String publicCertificateFileExtension) {
        this.publicCertificateFileExtension = publicCertificateFileExtension;
    }

    public void setPrivateKeyFileExtension(String privateKeyFileExtension) {
        this.privateKeyFileExtension = privateKeyFileExtension;
    }
}

