/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.appdeployer.command.security;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.marklogic.appdeployer.ConfigDir;
import com.marklogic.appdeployer.command.AbstractResourceCommand;
import com.marklogic.appdeployer.command.CommandContext;
import com.marklogic.appdeployer.command.SortOrderConstants;
import com.marklogic.appdeployer.command.SupportsCmaCommand;
import com.marklogic.mgmt.PayloadParser;
import com.marklogic.mgmt.api.configuration.Configuration;
import com.marklogic.mgmt.api.security.User;
import com.marklogic.mgmt.resource.ResourceManager;
import com.marklogic.mgmt.resource.security.UserManager;
import java.io.File;
import java.util.HashSet;
import java.util.Set;

public class DeployUsersCommand
extends AbstractResourceCommand
implements SupportsCmaCommand {
    private Set<String> defaultUsersToNotUndeploy = new HashSet<String>();

    public DeployUsersCommand() {
        this.setExecuteSortOrder(SortOrderConstants.DEPLOY_USERS);
        this.setUndoSortOrder(SortOrderConstants.DELETE_USERS);
        this.setSupportsResourceMerging(true);
        this.setResourceClassType(User.class);
        this.setResourceIdPropertyName("user-name");
        this.initializeDefaultUsersToNotUndeploy();
    }

    protected void initializeDefaultUsersToNotUndeploy() {
        this.defaultUsersToNotUndeploy = new HashSet<String>();
        this.defaultUsersToNotUndeploy.add("admin");
        this.defaultUsersToNotUndeploy.add("healthcheck");
        this.defaultUsersToNotUndeploy.add("infostudio-admin");
        this.defaultUsersToNotUndeploy.add("nobody");
    }

    @Override
    protected String adjustPayloadBeforeDeletingResource(ResourceManager mgr, CommandContext context, File f, String payload) {
        String username;
        if (this.defaultUsersToNotUndeploy != null && !this.defaultUsersToNotUndeploy.isEmpty() && (username = new PayloadParser().getPayloadFieldValue(payload, "user-name", false)) != null && this.defaultUsersToNotUndeploy.contains(username)) {
            this.logger.info(this.format("Not undeploying user '%s', as it's included in the list of users to not undeploy", new Object[]{username}));
            return null;
        }
        return super.adjustPayloadBeforeDeletingResource(mgr, context, f, payload);
    }

    @Override
    protected File[] getResourceDirs(CommandContext context) {
        return this.findResourceDirs(context.getAppConfig(), (ConfigDir configDir) -> configDir.getUsersDir());
    }

    @Override
    protected ResourceManager getResourceManager(CommandContext context) {
        return new UserManager(context.getManageClient());
    }

    @Override
    public boolean cmaShouldBeUsed(CommandContext context) {
        return context.getAppConfig().getCmaConfig().isDeployUsers();
    }

    @Override
    public void addResourceToConfiguration(ObjectNode resource, Configuration configuration) {
        configuration.addUser(resource);
    }

    @Override
    protected void deployConfiguration(CommandContext context, Configuration config) {
        if (context.getAppConfig().getCmaConfig().isCombineRequests()) {
            this.logger.info("Adding users to combined CMA request");
            context.addCmaConfigurationToCombinedRequest(config);
        } else {
            super.deployConfiguration(context, config);
        }
    }

    public Set<String> getDefaultUsersToNotUndeploy() {
        return this.defaultUsersToNotUndeploy;
    }

    public void setDefaultUsersToNotUndeploy(Set<String> defaultUsersToNotUndeploy) {
        this.defaultUsersToNotUndeploy = defaultUsersToNotUndeploy;
    }
}

