/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.appdeployer.command.security;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.marklogic.appdeployer.ConfigDir;
import com.marklogic.appdeployer.command.AbstractResourceCommand;
import com.marklogic.appdeployer.command.CommandContext;
import com.marklogic.appdeployer.command.SortOrderConstants;
import com.marklogic.appdeployer.command.SupportsCmaCommand;
import com.marklogic.mgmt.SaveReceipt;
import com.marklogic.mgmt.api.configuration.Configuration;
import com.marklogic.mgmt.api.configuration.Configurations;
import com.marklogic.mgmt.api.security.Role;
import com.marklogic.mgmt.api.security.RoleObjectNodesSorter;
import com.marklogic.mgmt.resource.ResourceManager;
import com.marklogic.mgmt.resource.security.RoleManager;
import com.marklogic.mgmt.util.ObjectMapperFactory;
import com.marklogic.mgmt.util.ObjectNodesSorter;
import com.marklogic.rest.util.ResourcesFragment;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DeployRolesCommand
extends AbstractResourceCommand
implements SupportsCmaCommand {
    private ObjectNodesSorter objectNodesSorter = new RoleObjectNodesSorter();

    public DeployRolesCommand() {
        this.setExecuteSortOrder(SortOrderConstants.DEPLOY_ROLES);
        this.setUndoSortOrder(SortOrderConstants.DELETE_ROLES);
        this.setSupportsResourceMerging(true);
        this.setResourceIdPropertyName("role-name");
        this.setResourceClassType(Role.class);
    }

    @Override
    protected boolean useCmaForDeployingResources(CommandContext context) {
        return true;
    }

    @Override
    public boolean cmaShouldBeUsed(CommandContext context) {
        return true;
    }

    @Override
    public void addResourceToConfiguration(ObjectNode resource, Configuration configuration) {
        configuration.addRole(resource);
    }

    @Override
    protected void deployConfiguration(CommandContext context, Configuration config) {
        List<ObjectNode> roleNodes = config.getRoles();
        if (roleNodes == null || roleNodes.isEmpty()) {
            return;
        }
        if (this.objectNodesSorter != null) {
            this.logger.info("Sorting roles before they are saved");
            roleNodes = this.objectNodesSorter.sortObjectNodes(roleNodes);
            config.setRoles(roleNodes);
        }
        if (context.getAppConfig().getCmaConfig().isDeployRoles() && this.cmaEndpointExists(context)) {
            this.submitRolesConfigurationViaCma(context, config);
        } else {
            this.submitRolesIndividually(context, roleNodes);
        }
    }

    protected void submitRolesConfigurationViaCma(CommandContext context, Configuration config) {
        this.submitConfigurationWithRolesThatReferenceThemselves(context, config.getRoles());
        if (context.getAppConfig().getCmaConfig().isCombineRequests()) {
            this.logger.info("Adding roles to combined CMA request");
            context.addCmaConfigurationToCombinedRequest(config);
        } else {
            super.deployConfiguration(context, config);
        }
    }

    protected void submitRolesIndividually(CommandContext context, List<ObjectNode> roleNodes) {
        RoleManager roleManager = new RoleManager(context.getManageClient());
        this.findRolesThatReferenceThemselves(context, roleNodes).forEach(role -> roleManager.save(this.format("{\"role-name\":\"%s\"}", new Object[]{role.getRoleName()})));
        roleNodes.forEach(roleNode -> {
            SaveReceipt receipt = this.saveResource((ResourceManager)roleManager, context, roleNode.toString());
            this.afterResourceSaved(roleManager, context, null, receipt);
        });
    }

    protected void submitConfigurationWithRolesThatReferenceThemselves(CommandContext context, List<ObjectNode> roles) {
        List<Role> rolesThatReferenceThemselves = this.findRolesThatReferenceThemselves(context, roles);
        if (!rolesThatReferenceThemselves.isEmpty()) {
            Configuration roleNamesOnlyConfig = new Configuration();
            rolesThatReferenceThemselves.forEach(role -> {
                ObjectNode node = ObjectMapperFactory.getObjectMapper().createObjectNode();
                node.put("role-name", role.getRoleName());
                roleNamesOnlyConfig.addRole(node);
            });
            this.logger.info("Submitting CMA configuration containing roles that reference themselves and do not yet exist");
            new Configurations(roleNamesOnlyConfig).submit(context.getManageClient());
        }
    }

    protected List<Role> findRolesThatReferenceThemselves(CommandContext context, List<ObjectNode> roles) {
        ObjectReader reader = ObjectMapperFactory.getObjectMapper().readerFor(Role.class);
        ArrayList<Role> rolesThatReferenceThemselves = new ArrayList<Role>();
        ResourcesFragment rolesXml = new RoleManager(context.getManageClient()).getAsXml();
        roles.forEach(role -> {
            try {
                Role r = (Role)reader.readValue((JsonNode)role);
                if (r.hasPermissionWithOwnRoleName() && !rolesXml.resourceExists(r.getRoleName())) {
                    rolesThatReferenceThemselves.add(r);
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to read ObjectNode into Role; node: " + role, e);
            }
        });
        return rolesThatReferenceThemselves;
    }

    @Override
    protected File[] getResourceDirs(CommandContext context) {
        return this.findResourceDirs(context, (ConfigDir configDir) -> configDir.getRolesDir());
    }

    @Override
    protected ResourceManager getResourceManager(CommandContext context) {
        return new RoleManager(context.getManageClient());
    }

    public void setObjectNodesSorter(ObjectNodesSorter objectNodesSorter) {
        this.objectNodesSorter = objectNodesSorter;
    }
}

