/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.appdeployer.command.security;

import com.marklogic.appdeployer.ConfigDir;
import com.marklogic.appdeployer.command.AbstractCommand;
import com.marklogic.appdeployer.command.CommandContext;
import com.marklogic.appdeployer.command.ResourceFilenameFilter;
import com.marklogic.appdeployer.command.SortOrderConstants;
import com.marklogic.mgmt.resource.security.CertificateAuthorityManager;
import java.io.File;
import java.util.HashSet;
import org.springframework.http.ResponseEntity;

public class DeployCertificateAuthoritiesCommand
extends AbstractCommand {
    public DeployCertificateAuthoritiesCommand() {
        this.setExecuteSortOrder(SortOrderConstants.DEPLOY_CERTIFICATE_AUTHORITIES);
        ResourceFilenameFilter filter = new ResourceFilenameFilter();
        HashSet<String> extensions = new HashSet<String>();
        extensions.add(".cer");
        extensions.add(".crt");
        extensions.add(".der");
        extensions.add(".p12");
        extensions.add(".p7b");
        extensions.add(".p7r");
        extensions.add(".pem");
        extensions.add(".pfx");
        extensions.add(".spc");
        filter.setSupportedFilenameExtensions(extensions);
        this.setResourceFilenameFilter(filter);
    }

    @Override
    public void execute(CommandContext context) {
        for (ConfigDir configDir : context.getAppConfig().getConfigDirs()) {
            File dir = configDir.getCertificateAuthoritiesDir();
            if (dir.exists()) {
                CertificateAuthorityManager mgr = new CertificateAuthorityManager(context.getManageClient());
                for (File f : this.listFilesInDirectory(dir)) {
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("Creating certificate authority from file: " + f.getAbsolutePath());
                    }
                    String payload = this.copyFileToString(f, context);
                    ResponseEntity<String> response = mgr.create(payload);
                    if (!this.logger.isInfoEnabled()) continue;
                    this.logger.info("Created certificate authority, location: " + response.getHeaders().getLocation());
                }
                continue;
            }
            this.logResourceDirectoryNotFound(dir);
        }
    }
}

