/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.appdeployer.command.forests;

import com.marklogic.appdeployer.ConfigDir;
import com.marklogic.appdeployer.command.AbstractCommand;
import com.marklogic.appdeployer.command.CommandContext;
import com.marklogic.appdeployer.command.SortOrderConstants;
import com.marklogic.appdeployer.command.forests.DefaultHostCalculator;
import com.marklogic.appdeployer.command.forests.ForestBuilder;
import com.marklogic.appdeployer.command.forests.ForestPlan;
import com.marklogic.appdeployer.command.forests.HostCalculator;
import com.marklogic.mgmt.api.API;
import com.marklogic.mgmt.api.configuration.Configuration;
import com.marklogic.mgmt.api.configuration.Configurations;
import com.marklogic.mgmt.api.forest.Forest;
import com.marklogic.mgmt.mapper.DefaultResourceMapper;
import com.marklogic.mgmt.resource.databases.DatabaseManager;
import com.marklogic.mgmt.resource.forests.ForestManager;
import com.marklogic.mgmt.resource.hosts.DefaultHostNameProvider;
import com.marklogic.mgmt.resource.hosts.HostManager;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.util.StringUtils;

public class DeployForestsCommand
extends AbstractCommand {
    public static final String DEFAULT_FOREST_PAYLOAD = "{\"forest-name\": \"%%FOREST_NAME%%\", \"host\": \"%%FOREST_HOST%%\", \"database\": \"%%FOREST_DATABASE%%\"}";
    private int forestsPerHost = 1;
    private String databaseName;
    private String forestFilename;
    private String forestPayload;
    private boolean createForestsOnEachHost = true;
    private HostCalculator hostCalculator;
    private ForestBuilder forestBuilder = new ForestBuilder();

    public DeployForestsCommand() {
        this.setExecuteSortOrder(SortOrderConstants.DEPLOY_FORESTS);
    }

    public DeployForestsCommand(String databaseName) {
        this();
        this.databaseName = databaseName;
    }

    @Override
    public void execute(CommandContext context) {
        List<Forest> forests = this.buildForests(context, false);
        if (context.getAppConfig().getCmaConfig().isDeployForests() && !forests.isEmpty() && this.cmaEndpointExists(context)) {
            this.createForestsViaCma(context, forests);
        } else {
            this.createForestsViaForestEndpoint(context, forests);
        }
    }

    protected void createForestsViaCma(CommandContext context, List<Forest> forests) {
        Configuration config = new Configuration();
        forests.forEach(forest -> config.addForest(forest.toObjectNode()));
        new Configurations(config).submit(context.getManageClient());
    }

    protected void createForestsViaForestEndpoint(CommandContext context, List<Forest> forests) {
        ForestManager forestManager = new ForestManager(context.getManageClient());
        for (Forest f : forests) {
            forestManager.save(f.getJson());
        }
    }

    public List<Forest> buildForests(CommandContext context, boolean includeReplicas) {
        int count;
        Map<String, Integer> map;
        String template = this.buildForestTemplate(context, new ForestManager(context.getManageClient()));
        List<String> hostNames = new HostManager(context.getManageClient()).getHostNames();
        hostNames = this.determineHostNamesForForest(context, hostNames);
        List<Forest> forests = this.getExistingPrimaryForests(context, this.databaseName);
        ForestPlan forestPlan = new ForestPlan(this.databaseName, hostNames).withTemplate(template).withForestsPerDataDirectory(this.forestsPerHost).withExistingForests(forests);
        if (includeReplicas && (map = context.getAppConfig().getDatabaseNamesAndReplicaCounts()) != null && (count = map.get(this.databaseName).intValue()) > 0) {
            forestPlan.withReplicaCount(count);
        }
        return this.forestBuilder.buildForests(forestPlan, context.getAppConfig());
    }

    protected List<Forest> getExistingPrimaryForests(CommandContext context, String databaseName) {
        List<String> forestIds = new DatabaseManager(context.getManageClient()).getPrimaryForestIds(databaseName);
        ForestManager forestMgr = new ForestManager(context.getManageClient());
        DefaultResourceMapper mapper = new DefaultResourceMapper(new API(context.getManageClient()));
        ArrayList<Forest> forests = new ArrayList<Forest>();
        for (String forestId : forestIds) {
            String json = forestMgr.getPropertiesAsJson(forestId, new String[0]);
            forests.add(mapper.readResource(json, Forest.class));
        }
        return forests;
    }

    protected String buildForestTemplate(CommandContext context, ForestManager forestManager) {
        String payload = null;
        if (this.forestFilename != null) {
            for (ConfigDir configDir : context.getAppConfig().getConfigDirs()) {
                File f;
                File dir = configDir.getForestsDir();
                if (!dir.exists() || !(f = new File(dir, this.forestFilename)).exists()) continue;
                payload = this.copyFileToString(f);
            }
        }
        if (payload == null && StringUtils.hasText((String)this.forestPayload)) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Creating forests using configured payload: " + this.forestPayload);
            }
            payload = this.forestPayload;
        }
        if (payload != null) {
            return this.adjustPayloadBeforeSavingResource(context, null, payload);
        }
        return null;
    }

    protected List<String> determineHostNamesForForest(CommandContext context, List<String> hostNames) {
        boolean onlyOnOneHost;
        Set<String> databaseNames = context.getAppConfig().getDatabasesWithForestsOnOneHost();
        boolean bl = onlyOnOneHost = databaseNames != null && databaseNames.contains(this.databaseName);
        if (!this.createForestsOnEachHost || onlyOnOneHost) {
            String first = hostNames.get(0);
            this.logger.info(this.format("Only creating forests on the first host: " + first, new Object[0]));
            hostNames = new ArrayList<String>();
            hostNames.add(first);
            return hostNames;
        }
        if (this.hostCalculator == null) {
            return new DefaultHostCalculator(new DefaultHostNameProvider(context.getManageClient())).calculateHostNames(this.databaseName, context);
        }
        return this.hostCalculator.calculateHostNames(this.databaseName, context);
    }

    public int getForestsPerHost() {
        return this.forestsPerHost;
    }

    public void setForestsPerHost(int forestsPerHost) {
        this.forestsPerHost = forestsPerHost;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getForestFilename() {
        return this.forestFilename;
    }

    public void setForestFilename(String forestFilename) {
        this.forestFilename = forestFilename;
    }

    public String getForestPayload() {
        return this.forestPayload;
    }

    public void setForestPayload(String forestPayload) {
        this.forestPayload = forestPayload;
    }

    public boolean isCreateForestsOnEachHost() {
        return this.createForestsOnEachHost;
    }

    public void setCreateForestsOnEachHost(boolean createForestsOnEachHost) {
        this.createForestsOnEachHost = createForestsOnEachHost;
    }

    public void setHostCalculator(HostCalculator hostCalculator) {
        this.hostCalculator = hostCalculator;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public void setForestBuilder(ForestBuilder forestBuilder) {
        this.forestBuilder = forestBuilder;
    }
}

