/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.appdeployer.command.forests;

import com.marklogic.appdeployer.AppConfig;
import com.marklogic.appdeployer.command.forests.ReplicaBuilderStrategy;
import com.marklogic.mgmt.api.forest.ForestReplica;
import java.util.Map;

public abstract class AbstractReplicaBuilderStrategy
implements ReplicaBuilderStrategy {
    protected void configureReplica(ForestReplica replica, String databaseName, AppConfig appConfig) {
        Map<String, String> map;
        replica.setFastDataDirectory(appConfig.getForestFastDataDirectory());
        replica.setLargeDataDirectory(appConfig.getForestLargeDataDirectory());
        if (databaseName != null) {
            map = appConfig.getDatabaseFastDataDirectories();
            if (map != null && map.containsKey(databaseName)) {
                replica.setFastDataDirectory(map.get(databaseName));
            }
            if ((map = appConfig.getDatabaseLargeDataDirectories()) != null && map.containsKey(databaseName)) {
                replica.setLargeDataDirectory(map.get(databaseName));
            }
        }
        if (appConfig.getReplicaForestFastDataDirectory() != null) {
            replica.setFastDataDirectory(appConfig.getReplicaForestFastDataDirectory());
        }
        if (appConfig.getReplicaForestLargeDataDirectory() != null) {
            replica.setLargeDataDirectory(appConfig.getReplicaForestLargeDataDirectory());
        }
        if (databaseName != null) {
            map = appConfig.getDatabaseReplicaFastDataDirectories();
            if (map != null && map.containsKey(databaseName)) {
                replica.setFastDataDirectory(map.get(databaseName));
            }
            if ((map = appConfig.getDatabaseReplicaLargeDataDirectories()) != null && map.containsKey(databaseName)) {
                replica.setLargeDataDirectory(map.get(databaseName));
            }
        }
    }
}

