/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.appdeployer.command.flexrep;

import com.marklogic.appdeployer.AppConfig;
import com.marklogic.appdeployer.ConfigDir;
import com.marklogic.appdeployer.command.AbstractResourceCommand;
import com.marklogic.appdeployer.command.CommandContext;
import com.marklogic.appdeployer.command.SortOrderConstants;
import com.marklogic.mgmt.resource.ResourceManager;
import com.marklogic.mgmt.resource.flexrep.PullManager;
import java.io.File;

public class DeployPullsCommand
extends AbstractResourceCommand {
    private ResourceManager pullManager;

    public DeployPullsCommand() {
        this.setExecuteSortOrder(SortOrderConstants.DEPLOY_FLEXREP_PULLS);
    }

    @Override
    protected File[] getResourceDirs(CommandContext context) {
        return this.findResourceDirs(context, (ConfigDir configDir) -> configDir.getFlexrepPullsDir());
    }

    @Override
    protected ResourceManager getResourceManager(CommandContext context) {
        return this.pullManager;
    }

    @Override
    public void execute(CommandContext context) {
        AppConfig appConfig = context.getAppConfig();
        for (ConfigDir configDir : appConfig.getConfigDirs()) {
            this.deployFlexRepPulls(context, configDir, appConfig.getContentDatabaseName());
            for (File dir : configDir.getDatabaseResourceDirectories()) {
                String databaseName = this.determineDatabaseNameForDatabaseResourceDirectory(context, configDir, dir);
                this.deployFlexRepPulls(context, new ConfigDir(dir), databaseName);
            }
        }
    }

    protected void deployFlexRepPulls(CommandContext context, ConfigDir configDir, String databaseIdOrName) {
        this.pullManager = new PullManager(context.getManageClient(), databaseIdOrName);
        this.processExecuteOnResourceDir(context, configDir.getFlexrepPullsDir());
    }
}

