/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.appdeployer.command.databases;

import com.marklogic.appdeployer.AppConfig;
import com.marklogic.appdeployer.ConfigDir;
import com.marklogic.appdeployer.command.AbstractCommand;
import com.marklogic.appdeployer.command.CommandContext;
import com.marklogic.appdeployer.command.SortOrderConstants;
import com.marklogic.appdeployer.command.UndoableCommand;
import com.marklogic.appdeployer.command.databases.DefaultDeployDatabaseCommandFactory;
import com.marklogic.appdeployer.command.databases.DeployDatabaseCommandFactory;
import com.marklogic.appdeployer.command.databases.DeploySubDatabasesCommand;
import com.marklogic.appdeployer.command.forests.DeployForestsCommand;
import com.marklogic.mgmt.PayloadParser;
import com.marklogic.mgmt.api.database.Database;
import com.marklogic.mgmt.resource.databases.DatabaseManager;
import java.io.File;
import java.util.Set;

public class DeployDatabaseCommand
extends AbstractCommand
implements UndoableCommand {
    private File databaseFile;
    private String databaseFilename;
    private boolean createDatabaseWithoutFile = false;
    private String databaseName;
    private boolean checkForCustomForests = true;
    private String forestFilename;
    private int forestsPerHost = 1;
    private boolean createForestsOnEachHost = true;
    private int undoSortOrder;
    private boolean subDatabase = false;
    private String superDatabaseName;
    private boolean postponeForestCreation = false;
    private DeployForestsCommand deployForestsCommand;
    private String payload;
    private Set<String> databasesToNotUndeploy;
    private DeployDatabaseCommandFactory deployDatabaseCommandFactory = new DefaultDeployDatabaseCommandFactory();

    public DeployDatabaseCommand() {
        this.setExecuteSortOrder(SortOrderConstants.DEPLOY_OTHER_DATABASES);
        this.setUndoSortOrder(SortOrderConstants.DELETE_OTHER_DATABASES);
        this.setResourceClassType(Database.class);
    }

    public DeployDatabaseCommand(File databaseFile) {
        this();
        this.databaseFile = databaseFile;
    }

    public DeployDatabaseCommand(String databaseFilename) {
        this();
        this.databaseFilename = databaseFilename;
    }

    public String toString() {
        if (this.databaseFile != null) {
            return this.databaseFile.getAbsolutePath();
        }
        return this.databaseFilename;
    }

    @Override
    public Integer getUndoSortOrder() {
        return this.undoSortOrder;
    }

    @Override
    public void execute(CommandContext context) {
        String payload = this.buildPayloadForSaving(context);
        if (payload != null) {
            DatabaseManager dbMgr = new DatabaseManager(context.getManageClient());
            this.databaseName = dbMgr.getResourceId(payload);
            dbMgr.save(payload);
            DeployForestsCommand tempCommand = this.buildDeployForestsCommand(this.databaseName, context);
            if (tempCommand != null) {
                this.deployForestsCommand = tempCommand;
                if (this.postponeForestCreation) {
                    this.logger.info("Postponing creation of forests for database: " + this.databaseName);
                } else {
                    this.deployForestsCommand.execute(context);
                }
            }
            this.deploySubDatabases(this.databaseName, context);
        }
    }

    public void deploySubDatabases(String dbName, CommandContext context) {
        if (!this.isSubDatabase()) {
            new DeploySubDatabasesCommand(dbName, this.deployDatabaseCommandFactory).execute(context);
        }
    }

    public String buildPayloadForSaving(CommandContext context) {
        String payload = this.buildPayload(context);
        if (payload != null) {
            payload = this.adjustPayloadBeforeSavingResource(context, null, payload);
        }
        return payload;
    }

    @Override
    public void undo(CommandContext context) {
        String dbName;
        String payload = this.buildPayload(context);
        if (this.databasesToNotUndeploy != null && (dbName = new PayloadParser().getPayloadFieldValue(payload, "database-name", false)) != null && this.databasesToNotUndeploy.contains(dbName)) {
            this.logger.info(this.format("Not undeploying database %s because it is in the list of database names to not undeploy.", new Object[]{dbName}));
            return;
        }
        if (payload != null) {
            DatabaseManager dbMgr = this.newDatabaseManageForDeleting(context);
            if (!this.isSubDatabase()) {
                String dbName2 = dbMgr.getResourceId(payload);
                new DeploySubDatabasesCommand(dbName2, this.deployDatabaseCommandFactory).undo(context);
            }
            dbMgr.delete(payload, new String[0]);
        }
    }

    protected DatabaseManager newDatabaseManageForDeleting(CommandContext context) {
        DatabaseManager dbMgr = new DatabaseManager(context.getManageClient());
        dbMgr.setForestDelete(this.getForestDeleteLevel(context.getAppConfig()));
        dbMgr.setDeleteReplicas(context.getAppConfig().isDeleteReplicas());
        return dbMgr;
    }

    protected String getForestDeleteLevel(AppConfig appConfig) {
        return appConfig.isDeleteForests() ? "data" : "configuration";
    }

    public String buildPayload(CommandContext context) {
        String payload = this.getPayload(context);
        return payload != null ? this.payloadTokenReplacer.replaceTokens(payload, context.getAppConfig(), false) : null;
    }

    protected String getPayload(CommandContext context) {
        if (this.payload != null) {
            return this.payload;
        }
        File f = null;
        if (this.databaseFile != null) {
            f = this.databaseFile;
        } else if (this.databaseFilename != null) {
            if (this.isSubDatabase()) {
                for (ConfigDir configDir : context.getAppConfig().getConfigDirs()) {
                    String subDbFileName = configDir.getDatabasesDir() + File.separator + "subdatabases" + File.separator + this.getSuperDatabaseName() + File.separator + this.databaseFilename;
                    File tmpFile = new File(subDbFileName);
                    if (tmpFile == null || !tmpFile.exists()) continue;
                    f = tmpFile;
                }
            } else {
                for (ConfigDir configDir : context.getAppConfig().getConfigDirs()) {
                    File tmpFile;
                    File dbDir = configDir.getDatabasesDir();
                    if (dbDir == null || !dbDir.exists() || (tmpFile = new File(dbDir, this.databaseFilename)) == null || !tmpFile.exists()) continue;
                    f = tmpFile;
                }
            }
        }
        if (f != null && f.exists()) {
            return this.copyFileToString(f);
        }
        if (this.createDatabaseWithoutFile) {
            return this.buildDefaultDatabasePayload(context);
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info(this.format("Database file '%s' does not exist, so not executing", new Object[]{this.databaseFilename}));
        }
        return null;
    }

    protected boolean shouldCreateForests(String databaseName, CommandContext context) {
        if (!context.getAppConfig().isCreateForests()) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Forest creation is disabled, so not creating any forests");
            }
            return false;
        }
        if (this.isCheckForCustomForests()) {
            boolean customForestsDontExist;
            boolean bl = customForestsDontExist = !this.customForestsExist(context, databaseName);
            if (!customForestsDontExist && this.logger.isInfoEnabled()) {
                this.logger.info("Found custom forests for database " + databaseName + ", so not creating default forests");
            }
            return customForestsDontExist;
        }
        return true;
    }

    protected boolean customForestsExist(CommandContext context, String dbName) {
        for (ConfigDir configDir : context.getAppConfig().getConfigDirs()) {
            File dbDir;
            File dir = configDir.getForestsDir();
            if (!dir.exists() || !(dbDir = new File(dir, dbName)).exists()) continue;
            return dbDir.listFiles().length > 0;
        }
        return false;
    }

    public DeployForestsCommand buildDeployForestsCommand(String databaseName, CommandContext context) {
        if (this.shouldCreateForests(databaseName, context)) {
            DeployForestsCommand c = new DeployForestsCommand(databaseName);
            c.setForestsPerHost(this.getForestsPerHost());
            c.setCreateForestsOnEachHost(this.createForestsOnEachHost);
            c.setForestFilename(this.forestFilename);
            return c;
        }
        return null;
    }

    protected String buildDefaultDatabasePayload(CommandContext context) {
        return this.format("{\"database-name\": \"%s\"}", new Object[]{this.databaseName});
    }

    public int getForestsPerHost() {
        return this.forestsPerHost;
    }

    public void setForestsPerHost(int forestsPerHost) {
        this.forestsPerHost = forestsPerHost;
    }

    public String getForestFilename() {
        return this.forestFilename;
    }

    public void setForestFilename(String forestFilename) {
        this.forestFilename = forestFilename;
    }

    public void setUndoSortOrder(int undoSortOrder) {
        this.undoSortOrder = undoSortOrder;
    }

    public String getDatabaseFilename() {
        return this.databaseFilename;
    }

    public void setDatabaseFilename(String databaseFilename) {
        this.databaseFilename = databaseFilename;
    }

    public boolean isCreateDatabaseWithoutFile() {
        return this.createDatabaseWithoutFile;
    }

    public void setCreateDatabaseWithoutFile(boolean createDatabaseWithoutFile) {
        this.createDatabaseWithoutFile = createDatabaseWithoutFile;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public boolean isCreateForestsOnEachHost() {
        return this.createForestsOnEachHost;
    }

    public void setCreateForestsOnEachHost(boolean createForestsOnEachHost) {
        this.createForestsOnEachHost = createForestsOnEachHost;
    }

    public boolean isCheckForCustomForests() {
        return this.checkForCustomForests;
    }

    public void setCheckForCustomForests(boolean checkForCustomForests) {
        this.checkForCustomForests = checkForCustomForests;
    }

    public void setSubDatabase(boolean isSubDatabase) {
        this.subDatabase = isSubDatabase;
    }

    public boolean isSubDatabase() {
        return this.subDatabase;
    }

    public void setSuperDatabaseName(String name) {
        this.superDatabaseName = name;
    }

    public String getSuperDatabaseName() {
        return this.superDatabaseName;
    }

    public void setDatabaseFile(File databaseFile) {
        this.databaseFile = databaseFile;
    }

    public Set<String> getDatabasesToNotUndeploy() {
        return this.databasesToNotUndeploy;
    }

    public void setDatabasesToNotUndeploy(Set<String> databasesToNotUndeploy) {
        this.databasesToNotUndeploy = databasesToNotUndeploy;
    }

    public void setDeployDatabaseCommandFactory(DeployDatabaseCommandFactory deployDatabaseCommandFactory) {
        this.deployDatabaseCommandFactory = deployDatabaseCommandFactory;
    }

    public void setPostponeForestCreation(boolean postponeForestCreation) {
        this.postponeForestCreation = postponeForestCreation;
    }

    public boolean isPostponeForestCreation() {
        return this.postponeForestCreation;
    }

    public DeployForestsCommand getDeployForestsCommand() {
        return this.deployForestsCommand;
    }

    public void setPayload(String payload) {
        this.payload = payload;
    }
}

