/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.appdeployer.command.cpf;

import com.marklogic.appdeployer.AppConfig;
import com.marklogic.appdeployer.ConfigDir;
import com.marklogic.appdeployer.command.AbstractCommand;
import com.marklogic.appdeployer.command.CommandContext;
import com.marklogic.mgmt.resource.cpf.AbstractCpfResourceManager;
import java.io.File;

public abstract class AbstractCpfResourceCommand
extends AbstractCommand {
    private String databaseIdOrName;

    protected abstract File getCpfResourceDir(ConfigDir var1);

    protected abstract AbstractCpfResourceManager getResourceManager(CommandContext var1, String var2);

    @Override
    public void execute(CommandContext context) {
        AppConfig config = context.getAppConfig();
        for (ConfigDir configDir : config.getConfigDirs()) {
            File dir = this.getCpfResourceDir(configDir);
            if (dir.exists()) {
                String db = this.databaseIdOrName != null ? this.databaseIdOrName : config.getCpfDatabaseName();
                AbstractCpfResourceManager mgr = this.getResourceManager(context, db);
                for (File f : this.listFilesInDirectory(dir)) {
                    String payload = this.copyFileToString(f, context);
                    mgr.save(payload);
                }
                continue;
            }
            this.logResourceDirectoryNotFound(dir);
        }
    }

    public void setDatabaseIdOrName(String databaseIdOrName) {
        this.databaseIdOrName = databaseIdOrName;
    }
}

