/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.appdeployer.command.appservers;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.marklogic.appdeployer.ConfigDir;
import com.marklogic.appdeployer.command.AbstractResourceCommand;
import com.marklogic.appdeployer.command.CommandContext;
import com.marklogic.appdeployer.command.ResourceFilenameFilter;
import com.marklogic.appdeployer.command.ResourceReference;
import com.marklogic.appdeployer.command.SortOrderConstants;
import com.marklogic.appdeployer.command.SupportsCmaCommand;
import com.marklogic.mgmt.PayloadParser;
import com.marklogic.mgmt.api.configuration.Configuration;
import com.marklogic.mgmt.api.server.Server;
import com.marklogic.mgmt.resource.ResourceManager;
import com.marklogic.mgmt.resource.appservers.ServerManager;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiPredicate;
import org.apache.commons.lang3.builder.EqualsBuilder;

public class DeployOtherServersCommand
extends AbstractResourceCommand
implements SupportsCmaCommand {
    private Set<String> defaultServersToNotUndeploy = new HashSet<String>();

    public DeployOtherServersCommand() {
        this.setExecuteSortOrder(SortOrderConstants.DEPLOY_OTHER_SERVERS);
        this.setUndoSortOrder(SortOrderConstants.DELETE_OTHER_SERVERS);
        this.setRestartAfterDelete(true);
        this.setCatchExceptionOnDeleteFailure(true);
        this.setResourceFilenameFilter(new ResourceFilenameFilter("rest-api-server.xml", "rest-api-server.json"));
        this.initializeDefaultServersToNotUndeploy();
        this.setSupportsResourceMerging(true);
        this.setResourceClassType(Server.class);
    }

    @Override
    public boolean cmaShouldBeUsed(CommandContext context) {
        return context.getAppConfig().getCmaConfig().isDeployServers();
    }

    @Override
    public void addResourceToConfiguration(ObjectNode resource, Configuration configuration) {
        configuration.addServer(resource);
    }

    protected void initializeDefaultServersToNotUndeploy() {
        this.defaultServersToNotUndeploy = new HashSet<String>();
        this.defaultServersToNotUndeploy.add("Admin");
        this.defaultServersToNotUndeploy.add("App-Services");
        this.defaultServersToNotUndeploy.add("HealthCheck");
        this.defaultServersToNotUndeploy.add("Manage");
    }

    @Override
    protected File[] getResourceDirs(CommandContext context) {
        return this.findResourceDirs(context.getAppConfig(), (ConfigDir configDir) -> configDir.getServersDir());
    }

    @Override
    protected ResourceManager getResourceManager(CommandContext context) {
        return new ServerManager(context.getManageClient(), context.getAppConfig().getGroupName());
    }

    @Override
    protected ResourceManager adjustResourceManagerForPayload(ResourceManager mgr, CommandContext context, String payload) {
        String groupName = new PayloadParser().getPayloadFieldValue(payload, "group-name", false);
        if (groupName != null && !groupName.equals(context.getAppConfig().getGroupName())) {
            return new ServerManager(context.getManageClient(), groupName);
        }
        return mgr;
    }

    @Override
    protected String adjustPayloadBeforeDeletingResource(ResourceManager mgr, CommandContext context, File f, String payload) {
        String serverName = new PayloadParser().getPayloadFieldValue(payload, "server-name", false);
        if (serverName != null && !this.shouldUndeployServer(serverName, context)) {
            this.logger.info(this.format("Not undeploying server %s because it's in the list of server names to not undeploy", new Object[]{serverName}));
            return null;
        }
        return super.adjustPayloadBeforeDeletingResource(mgr, context, f, payload);
    }

    @Override
    protected BiPredicate<ResourceReference, ResourceReference> getBiPredicateForMergingResources() {
        return (reference1, reference2) -> {
            ObjectNode node1 = reference1.getObjectNode();
            ObjectNode node2 = reference2.getObjectNode();
            EqualsBuilder b = new EqualsBuilder();
            b.append((Object)(node1.has("server-name") ? node1.get("server-name").asText() : null), node2.has("server-name") ? node2.get("server-name").asText() : null);
            b.append((Object)(node1.has("group-name") ? node1.get("group-name").asText() : "Default"), (Object)(node2.has("group-name") ? node2.get("group-name").asText() : "Default"));
            return b.isEquals();
        };
    }

    public boolean shouldUndeployServer(String serverName, CommandContext context) {
        return this.defaultServersToNotUndeploy == null || !this.defaultServersToNotUndeploy.contains(serverName);
    }

    public Set<String> getDefaultServersToNotUndeploy() {
        return this.defaultServersToNotUndeploy;
    }

    public void setDefaultServersToNotUndeploy(Set<String> defaultServersToNotUndeploy) {
        this.defaultServersToNotUndeploy = defaultServersToNotUndeploy;
    }
}

