/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.appdeployer.command.alert;

import com.marklogic.appdeployer.AppConfig;
import com.marklogic.appdeployer.ConfigDir;
import com.marklogic.appdeployer.command.AbstractCommand;
import com.marklogic.appdeployer.command.CommandContext;
import com.marklogic.appdeployer.command.SortOrderConstants;
import com.marklogic.mgmt.resource.ResourceManager;
import com.marklogic.mgmt.resource.alert.AlertActionManager;
import java.io.File;

public class DeployAlertActionsCommand
extends AbstractCommand {
    private String actionsDirectorySuffix = "-actions";

    public DeployAlertActionsCommand() {
        this.setExecuteSortOrder(SortOrderConstants.DEPLOY_ALERT_ACTIONS);
    }

    @Override
    public void execute(CommandContext context) {
        AppConfig appConfig = context.getAppConfig();
        for (ConfigDir configDir : appConfig.getConfigDirs()) {
            this.deployActions(context, configDir, appConfig.getContentDatabaseName());
            for (File dir : configDir.getDatabaseResourceDirectories()) {
                String databaseName = this.determineDatabaseNameForDatabaseResourceDirectory(context, configDir, dir);
                this.deployActions(context, new ConfigDir(dir), databaseName);
            }
        }
    }

    protected void deployActions(CommandContext context, ConfigDir configDir, String databaseIdOrName) {
        File configsDir = configDir.getAlertConfigsDir();
        if (configsDir != null && configsDir.exists()) {
            for (File f : configsDir.listFiles()) {
                if (!f.isDirectory() || !f.getName().endsWith(this.actionsDirectorySuffix)) continue;
                this.deployActionsInDirectory(f, context, databaseIdOrName);
            }
        } else {
            this.logResourceDirectoryNotFound(configsDir);
        }
    }

    protected void deployActionsInDirectory(File dir, CommandContext context, String databaseIdOrName) {
        String configUri = this.extractConfigUriFromDirectory(dir);
        if (this.logger.isInfoEnabled()) {
            this.logger.info(this.format("Deploying alert actions with config URI '%s' in directory: %s", new Object[]{configUri, dir.getAbsolutePath()}));
        }
        AlertActionManager mgr = new AlertActionManager(context.getManageClient(), databaseIdOrName, configUri);
        for (File f : this.listFilesInDirectory(dir)) {
            this.saveResource((ResourceManager)mgr, context, f);
        }
    }

    protected String extractConfigUriFromDirectory(File dir) {
        String name = dir.getName();
        return name.substring(0, name.length() - this.actionsDirectorySuffix.length());
    }

    public void setActionsDirectorySuffix(String targetDirectorySuffix) {
        this.actionsDirectorySuffix = targetDirectorySuffix;
    }
}

