/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.appdeployer.command.admin;

import com.marklogic.appdeployer.command.AbstractCommand;
import com.marklogic.appdeployer.command.CommandContext;

public class RequireAtLeastMl8Command
extends AbstractCommand {
    @Override
    public void execute(CommandContext context) {
        int major = 0;
        try {
            String version = context.getAdminManager().getServerVersion();
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Verifying MarkLogic version is at least 8 or higher; version: " + version);
            }
            major = Integer.parseInt(version.split("\\.")[0]);
        }
        catch (Exception e) {
            this.logger.warn("Unable to verify MarkLogic version is 8 or higher, will continue with deployment; error: " + e.getMessage());
            major = 8;
        }
        if (major < 8) {
            throw new RuntimeException("Only MarkLogic versions 8 and higher are supported");
        }
    }
}

