/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.appdeployer.command;

import com.marklogic.appdeployer.command.IncrementalFilenameFilter;
import com.marklogic.appdeployer.command.ResourceFileManager;
import com.marklogic.appdeployer.command.ResourceFileManagerImpl;
import com.marklogic.client.ext.helper.LoggingObject;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;

public class ResourceFilenameFilter
extends LoggingObject
implements IncrementalFilenameFilter {
    private Set<String> filenamesToIgnore;
    private Pattern excludePattern;
    private Pattern includePattern;
    private ResourceFileManager resourceFileManager;
    private boolean incrementalMode = false;
    private Set<String> supportedFilenameExtensions = new HashSet<String>();

    public ResourceFilenameFilter() {
        this(new ResourceFileManagerImpl());
    }

    public ResourceFilenameFilter(ResourceFileManager resourceFileManager) {
        this.resourceFileManager = resourceFileManager;
        this.resourceFileManager.initialize();
        this.supportedFilenameExtensions.add(".xml");
        this.supportedFilenameExtensions.add(".json");
    }

    public ResourceFilenameFilter(String ... filenamesToIgnore) {
        this();
        this.filenamesToIgnore = new HashSet<String>();
        for (String f : filenamesToIgnore) {
            this.filenamesToIgnore.add(f);
        }
    }

    public ResourceFilenameFilter(Set<String> filenamesToIgnore) {
        this();
        this.filenamesToIgnore = filenamesToIgnore;
    }

    @Override
    public boolean accept(File dir, String filename) {
        if (this.excludePattern != null && this.includePattern != null) {
            throw new IllegalStateException("Both excludePattern and includePattern cannot be specified");
        }
        if (this.excludePattern != null && this.excludePattern.matcher(filename).matches()) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info(this.format("Filename %s matches excludePattern, so ignoring", new Object[]{filename}));
            }
            return false;
        }
        if (this.includePattern != null && !this.includePattern.matcher(filename).matches()) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info(this.format("Filename %s doesn't match includePattern, so ignoring", new Object[]{filename}));
            }
            return false;
        }
        if (this.filenamesToIgnore != null && this.filenamesToIgnore.contains(filename)) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Ignoring filename: " + filename);
            }
            return false;
        }
        if (this.filenameHasSupportedExtension(filename)) {
            if (this.incrementalMode) {
                return this.acceptFileBasedOnIncrementalCheck(dir, filename);
            }
            return true;
        }
        return false;
    }

    protected boolean filenameHasSupportedExtension(String filename) {
        if (filename == null) {
            return false;
        }
        for (String extension : this.supportedFilenameExtensions) {
            if (!filename.endsWith(extension)) continue;
            return true;
        }
        return false;
    }

    protected boolean acceptFileBasedOnIncrementalCheck(File dir, String filename) {
        return this.resourceFileManager.shouldResourceFileBeProcessed(new File(dir, filename));
    }

    public void setFilenamesToIgnore(Set<String> ignoreFilenames) {
        this.filenamesToIgnore = ignoreFilenames;
    }

    public Set<String> getFilenamesToIgnore() {
        return this.filenamesToIgnore;
    }

    public Pattern getExcludePattern() {
        return this.excludePattern;
    }

    public void setExcludePattern(Pattern excludePattern) {
        this.excludePattern = excludePattern;
    }

    public Pattern getIncludePattern() {
        return this.includePattern;
    }

    public void setIncludePattern(Pattern includePattern) {
        this.includePattern = includePattern;
    }

    @Override
    public void setIncrementalMode(boolean incrementalMode) {
        this.incrementalMode = incrementalMode;
    }

    public void setResourceFileManager(ResourceFileManager resourceFileManager) {
        this.resourceFileManager = resourceFileManager;
    }

    public Set<String> getSupportedFilenameExtensions() {
        return this.supportedFilenameExtensions;
    }

    public void setSupportedFilenameExtensions(Set<String> supportedFilenameExtensions) {
        this.supportedFilenameExtensions = supportedFilenameExtensions;
    }

    public ResourceFileManager getResourceFileManager() {
        return this.resourceFileManager;
    }
}

