/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.appdeployer.command;

import com.marklogic.appdeployer.AppConfig;
import com.marklogic.mgmt.ManageClient;
import com.marklogic.mgmt.admin.AdminManager;
import com.marklogic.mgmt.api.configuration.Configuration;
import com.marklogic.mgmt.api.configuration.Configurations;
import java.util.HashMap;
import java.util.Map;

public class CommandContext {
    private AppConfig appConfig;
    private ManageClient manageClient;
    private AdminManager adminManager;
    private Map<String, Object> contextMap;
    private static final String COMBINED_CMA_REQUEST_KEY = "cma-combined-request";

    public CommandContext(AppConfig appConfig, ManageClient manageClient, AdminManager adminManager) {
        this.appConfig = appConfig;
        this.manageClient = manageClient;
        this.adminManager = adminManager;
        this.contextMap = new HashMap<String, Object>();
    }

    public void addCmaConfigurationToCombinedRequest(Configuration configuration) {
        Configurations configs = this.getCombinedCmaRequest();
        if (configs == null) {
            this.contextMap.put(COMBINED_CMA_REQUEST_KEY, new Configurations(configuration));
        } else {
            configs.addConfig(configuration);
        }
    }

    public Configurations getCombinedCmaRequest() {
        return (Configurations)this.contextMap.get(COMBINED_CMA_REQUEST_KEY);
    }

    public void removeCombinedCmaRequest() {
        this.contextMap.remove(COMBINED_CMA_REQUEST_KEY);
    }

    public AppConfig getAppConfig() {
        return this.appConfig;
    }

    public ManageClient getManageClient() {
        return this.manageClient;
    }

    public AdminManager getAdminManager() {
        return this.adminManager;
    }

    public Map<String, Object> getContextMap() {
        return this.contextMap;
    }

    public void setContextMap(Map<String, Object> contextMap) {
        this.contextMap = contextMap;
    }
}

