/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.appdeployer.command;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.marklogic.appdeployer.ConfigDir;
import com.marklogic.appdeployer.command.Command;
import com.marklogic.appdeployer.command.CommandContext;
import com.marklogic.appdeployer.command.DefaultPayloadTokenReplacer;
import com.marklogic.appdeployer.command.IncrementalFilenameFilter;
import com.marklogic.appdeployer.command.PayloadTokenReplacer;
import com.marklogic.appdeployer.command.ResourceFilenameFilter;
import com.marklogic.appdeployer.command.ResourceReference;
import com.marklogic.client.ext.helper.LoggingObject;
import com.marklogic.mgmt.PayloadParser;
import com.marklogic.mgmt.SaveReceipt;
import com.marklogic.mgmt.admin.AdminManager;
import com.marklogic.mgmt.api.API;
import com.marklogic.mgmt.api.Resource;
import com.marklogic.mgmt.api.configuration.Configuration;
import com.marklogic.mgmt.api.configuration.Configurations;
import com.marklogic.mgmt.cma.ConfigurationManager;
import com.marklogic.mgmt.mapper.DefaultResourceMapper;
import com.marklogic.mgmt.mapper.ResourceMapper;
import com.marklogic.mgmt.resource.ResourceManager;
import com.marklogic.mgmt.resource.databases.DatabaseManager;
import com.marklogic.mgmt.util.ObjectMapperFactory;
import com.marklogic.rest.util.JsonNodeUtil;
import com.marklogic.rest.util.PropertyBasedBiPredicate;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.regex.Pattern;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.util.FileCopyUtils;

public abstract class AbstractCommand
extends LoggingObject
implements Command {
    private int executeSortOrder = Integer.MAX_VALUE;
    private boolean storeResourceIdsAsCustomTokens = false;
    protected PayloadTokenReplacer payloadTokenReplacer = new DefaultPayloadTokenReplacer();
    private FilenameFilter resourceFilenameFilter = new ResourceFilenameFilter();
    private PayloadParser payloadParser = new PayloadParser();
    private Class<? extends Resource> resourceClassType;
    private String resourceIdPropertyName;
    private ResourceMapper resourceMapper;
    private boolean supportsResourceMerging = false;

    @Override
    public Integer getExecuteSortOrder() {
        return this.executeSortOrder;
    }

    public void setFilenamesToIgnore(String ... filenames) {
        if (filenames == null || filenames.length == 0) {
            return;
        }
        if (this.resourceFilenameFilter != null) {
            if (this.resourceFilenameFilter instanceof ResourceFilenameFilter) {
                ResourceFilenameFilter rff = (ResourceFilenameFilter)this.resourceFilenameFilter;
                Set<String> set = null;
                set = rff.getFilenamesToIgnore() != null ? rff.getFilenamesToIgnore() : new HashSet<String>();
                for (String f : filenames) {
                    set.add(f);
                }
                rff.setFilenamesToIgnore(set);
            } else {
                this.logger.warn("resourceFilenameFilter is not an instanceof ResourceFilenameFilter, so unable to set resource filenames to ignore");
            }
        } else {
            this.resourceFilenameFilter = new ResourceFilenameFilter(filenames);
        }
    }

    public void setResourceFilenamesExcludePattern(Pattern pattern) {
        if (this.resourceFilenameFilter != null) {
            if (this.resourceFilenameFilter instanceof ResourceFilenameFilter) {
                ((ResourceFilenameFilter)this.resourceFilenameFilter).setExcludePattern(pattern);
            } else {
                this.logger.warn("resourceFilenameFilter is not an instanceof ResourceFilenameFilter, so unable to set exclude pattern");
            }
        } else {
            ResourceFilenameFilter rff = new ResourceFilenameFilter();
            rff.setExcludePattern(pattern);
            this.resourceFilenameFilter = rff;
        }
    }

    public void setResourceFilenamesIncludePattern(Pattern pattern) {
        if (this.resourceFilenameFilter != null) {
            if (this.resourceFilenameFilter instanceof ResourceFilenameFilter) {
                ((ResourceFilenameFilter)this.resourceFilenameFilter).setIncludePattern(pattern);
            } else {
                this.logger.warn("resourceFilenameFilter is not an instanceof ResourceFilenameFilter, so unable to set include pattern");
            }
        } else {
            ResourceFilenameFilter rff = new ResourceFilenameFilter();
            rff.setIncludePattern(pattern);
            this.resourceFilenameFilter = rff;
        }
    }

    protected String copyFileToString(File f) {
        try {
            File absoluteFile = f.getAbsoluteFile();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Copying content from absolute file path: " + absoluteFile.getPath() + "; input file path: " + f.getPath());
            }
            return new String(FileCopyUtils.copyToByteArray((File)f.getAbsoluteFile()));
        }
        catch (IOException ie) {
            throw new RuntimeException("Unable to copy file to string from path: " + f.getAbsolutePath() + "; cause: " + ie.getMessage(), ie);
        }
    }

    protected String copyFileToString(File f, CommandContext context) {
        String str = this.copyFileToString(f);
        return str != null ? this.payloadTokenReplacer.replaceTokens(str, context.getAppConfig(), false) : str;
    }

    protected SaveReceipt saveResource(ResourceManager mgr, CommandContext context, File resourceFile) {
        String payload = this.readResourceFromFile(context, resourceFile);
        if (payload != null && this.resourceMergingIsSupported(context)) {
            try {
                this.storeResourceInCommandContextMap(context, resourceFile, payload);
                return null;
            }
            catch (Exception ex) {
                this.logger.warn("Unable to store resource in context map so it can be merged (if needed) and saved later, so the resource will instead be saved immediately. Error cause: " + ex.getMessage());
            }
        }
        return this.saveResource(mgr, context, payload);
    }

    protected boolean resourceMergingIsSupported(CommandContext context) {
        return this.supportsResourceMerging && context.getAppConfig().isMergeResources();
    }

    protected void storeResourceInCommandContextMap(CommandContext context, File resourceFile, String payload) {
        String contextKey = this.getContextKeyForResourcesToSave();
        ArrayList<ResourceReference> references = (ArrayList<ResourceReference>)context.getContextMap().get(contextKey);
        if (references == null) {
            references = new ArrayList<ResourceReference>();
            context.getContextMap().put(contextKey, references);
        }
        references.add(new ResourceReference(resourceFile, this.convertPayloadToObjectNode(context, payload)));
    }

    protected String getContextKeyForResourcesToSave() {
        return this.getClass().getName() + "-resources-to-save";
    }

    protected ObjectNode convertPayloadToObjectNode(CommandContext context, String payload) {
        payload = this.convertXmlPayloadToJsonIfNecessary(context, payload);
        try {
            return (ObjectNode)ObjectMapperFactory.getObjectMapper().readTree(payload);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read JSON into an ObjectNode, cause: " + e.getMessage(), e);
        }
    }

    protected String convertXmlPayloadToJsonIfNecessary(CommandContext context, String payload) {
        if (this.payloadParser.isJsonPayload(payload)) {
            return payload;
        }
        if (this.resourceClassType == null) {
            throw new IllegalStateException("Cannot convert an XML payload to JSON because resourceClassType is not defined");
        }
        if (this.resourceMapper == null) {
            this.resourceMapper = new DefaultResourceMapper(new API(context.getManageClient()));
        }
        return this.resourceMapper.readResource(payload, this.resourceClassType).getJson();
    }

    protected List<SaveReceipt> saveMergedResources(CommandContext context, ResourceManager resourceManager, List<ResourceReference> mergedReferences) {
        ArrayList<SaveReceipt> saveReceipts = new ArrayList<SaveReceipt>();
        for (ResourceReference reference : mergedReferences) {
            SaveReceipt receipt = this.saveResource(resourceManager, context, reference.getObjectNode().toString());
            if (receipt == null) continue;
            saveReceipts.add(receipt);
            this.afterResourceSaved(resourceManager, context, reference, receipt);
        }
        return saveReceipts;
    }

    protected SaveReceipt saveResource(ResourceManager mgr, CommandContext context, String payload) {
        mgr = this.adjustResourceManagerForPayload(mgr, context, payload);
        if (payload == null) {
            return null;
        }
        SaveReceipt receipt = mgr.save(payload);
        if (this.storeResourceIdsAsCustomTokens) {
            this.storeTokenForResourceId(receipt, context);
        }
        return receipt;
    }

    protected List<ResourceReference> mergeResources(List<ResourceReference> resources) {
        PropertyBasedBiPredicate biPredicate;
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Merging payloads that reference the same resource");
        }
        if ((biPredicate = this.resourceIdPropertyName != null ? new PropertyBasedBiPredicate(this.resourceIdPropertyName) : this.getBiPredicateForMergingResources()) == null) {
            throw new IllegalStateException("To merge resources, either resourceIdPropertyName must be set or getBiPredicateForMergingResources must return a BiPredicate");
        }
        return JsonNodeUtil.mergeObjectNodeList(resources, biPredicate);
    }

    protected BiPredicate<ResourceReference, ResourceReference> getBiPredicateForMergingResources() {
        return null;
    }

    protected String readResourceFromFile(CommandContext context, File f) {
        String payload = this.copyFileToString(f, context);
        return this.adjustPayloadBeforeSavingResource(context, f, payload);
    }

    protected void afterResourceSaved(ResourceManager mgr, CommandContext context, ResourceReference resourceReference, SaveReceipt receipt) {
        URI uri;
        HttpHeaders headers;
        if (receipt == null) {
            return;
        }
        ResponseEntity<String> response = receipt.getResponse();
        if (response != null && (headers = response.getHeaders()) != null && (uri = headers.getLocation()) != null && "/admin/v1/timestamp".equals(uri.getPath())) {
            AdminManager adminManager = context.getAdminManager();
            if (adminManager != null) {
                adminManager.waitForRestart();
            } else {
                this.logger.warn("Location header indicates ML is restarting, but no AdminManager available to support waiting for a restart");
            }
        }
    }

    protected String adjustPayloadBeforeSavingResource(CommandContext context, File f, String payload) {
        String[] props = context.getAppConfig().getExcludeProperties();
        if (props != null && props.length > 0) {
            this.logger.info(this.format("Excluding properties %s from payload", new Object[]{Arrays.asList(props).toString()}));
            payload = this.payloadParser.excludeProperties(payload, props);
        }
        if ((props = context.getAppConfig().getIncludeProperties()) != null && props.length > 0) {
            this.logger.info(this.format("Including only properties %s from payload", new Object[]{Arrays.asList(props).toString()}));
            payload = this.payloadParser.includeProperties(payload, props);
        }
        return payload;
    }

    protected ResourceManager adjustResourceManagerForPayload(ResourceManager mgr, CommandContext context, String payload) {
        return mgr;
    }

    protected void storeTokenForResourceId(SaveReceipt receipt, CommandContext context) {
        String[] tokens;
        URI location = receipt.getResponse() != null ? receipt.getResponse().getHeaders().getLocation() : null;
        String idValue = null;
        String resourceName = null;
        if (location != null) {
            tokens = location.getPath().split("/");
            idValue = tokens[tokens.length - 1];
            resourceName = tokens[tokens.length - 2];
        } else {
            tokens = receipt.getPath().split("/");
            idValue = tokens[tokens.length - 2];
            resourceName = tokens[tokens.length - 3];
        }
        String key = "%%" + resourceName + "-id-" + receipt.getResourceId() + "%%";
        if (this.logger.isInfoEnabled()) {
            this.logger.info(this.format("Storing token with key '%s' and value '%s'", new Object[]{key, idValue}));
        }
        context.getAppConfig().getCustomTokens().put(key, idValue);
    }

    protected File[] listFilesInDirectory(File dir) {
        Object[] files = dir.listFiles(this.resourceFilenameFilter);
        if (files != null && files.length > 1) {
            Arrays.sort(files);
        }
        return files;
    }

    protected void logResourceDirectoryNotFound(File dir) {
        if (dir != null && this.logger.isInfoEnabled()) {
            this.logger.info("No resource directory found at: " + dir.getAbsolutePath());
        }
    }

    protected boolean cmaEndpointExists(CommandContext context) {
        return new ConfigurationManager(context.getManageClient()).endpointExists();
    }

    protected void deployConfiguration(CommandContext context, Configuration config) {
        if (config.hasResources()) {
            new Configurations(config).submit(context.getManageClient());
        }
    }

    protected void setIncrementalMode(boolean incrementalMode) {
        if (this.resourceFilenameFilter instanceof IncrementalFilenameFilter) {
            ((IncrementalFilenameFilter)this.resourceFilenameFilter).setIncrementalMode(incrementalMode);
        } else {
            this.logger.warn("resourceFilenameFilter does not implement " + IncrementalFilenameFilter.class.getName() + ", and thus setIncrementalMode cannot be invoked");
        }
    }

    protected String determineDatabaseNameForDatabaseResourceDirectory(CommandContext context, ConfigDir configDir, File databaseResourceDir) {
        String dirName = databaseResourceDir.getName();
        if (new DatabaseManager(context.getManageClient()).exists(dirName, new String[0])) {
            return dirName;
        }
        File databasesDir = configDir.getDatabasesDir();
        for (File f : this.listFilesInDirectory(databasesDir)) {
            String name = f.getName();
            int index = name.lastIndexOf(46);
            String string = name = index > 0 ? name.substring(0, index) : name;
            if (!dirName.equals(name)) continue;
            this.logger.info("Found database file with same name, minus its extension, as the database resource directory; file: " + f);
            String payload = this.copyFileToString(f, context);
            String databaseName = new PayloadParser().getPayloadFieldValue(payload, "database-name");
            this.logger.info("Associating database resource directory with database: " + databaseName);
            return databaseName;
        }
        throw new RuntimeException("Could not determine database to associate with database resource directory: " + databaseResourceDir);
    }

    public void setPayloadTokenReplacer(PayloadTokenReplacer payloadTokenReplacer) {
        this.payloadTokenReplacer = payloadTokenReplacer;
    }

    public void setExecuteSortOrder(int executeSortOrder) {
        this.executeSortOrder = executeSortOrder;
    }

    public void setStoreResourceIdsAsCustomTokens(boolean storeResourceIdsAsCustomTokens) {
        this.storeResourceIdsAsCustomTokens = storeResourceIdsAsCustomTokens;
    }

    public void setResourceFilenameFilter(FilenameFilter resourceFilenameFilter) {
        this.resourceFilenameFilter = resourceFilenameFilter;
    }

    public FilenameFilter getResourceFilenameFilter() {
        return this.resourceFilenameFilter;
    }

    public boolean isStoreResourceIdsAsCustomTokens() {
        return this.storeResourceIdsAsCustomTokens;
    }

    public Class<? extends Resource> getResourceClassType() {
        return this.resourceClassType;
    }

    public void setResourceClassType(Class<? extends Resource> resourceClassType) {
        this.resourceClassType = resourceClassType;
    }

    public String getResourceIdPropertyName() {
        return this.resourceIdPropertyName;
    }

    public void setResourceIdPropertyName(String resourceIdPropertyName) {
        this.resourceIdPropertyName = resourceIdPropertyName;
    }

    public boolean isSupportsResourceMerging() {
        return this.supportsResourceMerging;
    }

    public void setSupportsResourceMerging(boolean supportsResourceMerging) {
        this.supportsResourceMerging = supportsResourceMerging;
    }
}

