/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.xcc.impl;

import com.marklogic.io.ResourcePool;
import com.marklogic.io.SslByteChannel;
import com.marklogic.xcc.Request;
import com.marklogic.xcc.SecurityOptions;
import com.marklogic.xcc.Session;
import com.marklogic.xcc.impl.SSLConnection;
import com.marklogic.xcc.impl.SocketPoolProvider;
import com.marklogic.xcc.spi.ConnectionErrorAction;
import com.marklogic.xcc.spi.ConnectionProvider;
import com.marklogic.xcc.spi.ServerConnection;
import com.marklogic.xcc.spi.SingleHostAddress;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.ByteChannel;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SSLSocketPoolProvider
implements ConnectionProvider,
SingleHostAddress {
    private final SocketAddress address;
    private final SecurityOptions securityOptions;
    private final SocketPoolProvider socketProvider;
    private final ResourcePool<SocketAddress, ServerConnection> sslPool;
    private final Logger logger = Logger.getLogger(ConnectionProvider.class.getName());

    public SSLSocketPoolProvider(SocketAddress address, SecurityOptions options) throws NoSuchAlgorithmException, KeyManagementException {
        this.logger.fine("constructing new SSLSocketPoolProvider");
        this.address = address;
        this.socketProvider = new SocketPoolProvider(address);
        this.securityOptions = options;
        this.sslPool = new ResourcePool();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof SSLSocketPoolProvider)) {
            return false;
        }
        return this.address.equals(((SSLSocketPoolProvider)o).getAddress()) && this.securityOptions.equals(((SSLSocketPoolProvider)o).getSecurityOptions());
    }

    public int hashCode() {
        return this.address.hashCode() + this.securityOptions.hashCode();
    }

    @Override
    public InetSocketAddress getAddress() {
        return (InetSocketAddress)(this.address instanceof InetSocketAddress ? this.address : null);
    }

    public SecurityOptions getSecurityOptions() {
        return this.securityOptions;
    }

    @Override
    public ServerConnection obtainConnection(Session session, Request request, Logger logger) throws IOException {
        ServerConnection conn = this.sslPool.get(this.address);
        if (conn != null) {
            return conn;
        }
        conn = this.socketProvider.obtainConnection(session, request, logger);
        return new SSLConnection(conn, this.securityOptions, this, logger);
    }

    @Override
    public void returnConnection(ServerConnection connection, Logger logger) {
        ByteChannel channel;
        if (this.getLogger(logger).isLoggable(Level.FINE)) {
            this.getLogger(logger).fine("returnConnection for " + this.address + ", expire=" + connection.getTimeoutMillis());
        }
        if ((channel = connection.channel()) == null || !(channel instanceof SslByteChannel)) {
            this.getLogger(logger).fine("channel is not eligible for pooling, dropping");
            try {
                channel.close();
            }
            catch (IOException e) {
                this.getLogger(logger).fine("unable to close channel");
            }
            return;
        }
        SslByteChannel socketChannel = (SslByteChannel)channel;
        if (!socketChannel.isOpen()) {
            this.getLogger(logger).fine("channel has been closed, dropping");
            return;
        }
        long timeoutMillis = connection.getTimeoutMillis();
        if (timeoutMillis <= 0L) {
            this.getLogger(logger).fine("channel has already expired, closing");
            connection.close();
            return;
        }
        long timeoutTime = connection.getTimeoutTime();
        if (this.getLogger(logger).isLoggable(Level.FINE)) {
            this.getLogger(logger).fine("returning socket to pool (" + this.address + "), timeout time=" + timeoutTime);
        }
        this.sslPool.put(this.address, connection, timeoutTime);
    }

    @Override
    public ConnectionErrorAction returnErrorConnection(ServerConnection connection, Throwable exception, Logger logger) {
        this.getLogger(logger).log(Level.FINE, "error return", exception);
        ByteChannel channel = connection.channel();
        if (channel != null) {
            if (channel.isOpen()) {
                try {
                    channel.close();
                }
                catch (IOException iOException) {}
            } else {
                this.getLogger(logger).warning("returned error connection is closed, retrying");
                return ConnectionErrorAction.RETRY;
            }
        }
        this.getLogger(logger).fine("returning FAIL action");
        return ConnectionErrorAction.FAIL;
    }

    @Override
    public void shutdown(Logger logger) {
        ServerConnection conn;
        this.getLogger(logger).fine("shutting down socket pool provider");
        while ((conn = this.sslPool.get(this.address)) != null) {
            conn.close();
        }
        this.socketProvider.shutdown(logger);
    }

    public String toString() {
        return "SSLconn address=" + this.address.toString() + ", pool=" + this.sslPool.size(this.address) + "/" + this.socketProvider.getPoolSize();
    }

    private Logger getLogger(Logger clientLogger) {
        return clientLogger == null ? this.logger : clientLogger;
    }

    @Override
    public void closeExpired(long currTime) {
        this.sslPool.closeExpired(currTime);
    }

    @Override
    public int getPort() {
        InetSocketAddress inetAddress = this.getAddress();
        return inetAddress == null ? 0 : inetAddress.getPort();
    }

    @Override
    public String getHostName() {
        InetSocketAddress inetAddress = this.getAddress();
        return inetAddress == null ? null : inetAddress.getHostName();
    }
}

