/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.xcc.impl;

import com.marklogic.io.Base64;
import com.marklogic.io.IOHelper;
import com.marklogic.xcc.ContentSource;
import com.marklogic.xcc.Session;
import com.marklogic.xcc.UserCredentials;
import com.marklogic.xcc.impl.SessionImpl;
import com.marklogic.xcc.spi.ConnectionProvider;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class ContentSourceImpl
implements ContentSource {
    private static final String DEFAULT_LOGGER_NAME = "com.marklogic.xcc";
    private static final String XCC_LOGGING_CONFIG_FILE = "xcc.logging.properties";
    private static final String XCC_CONFIG_FILE = "xcc.properties";
    private static final String SYSTEM_LOGGING_CONFIG_CLASS = "java.util.logging.config.class";
    private static final String SYSTEM_LOGGING_CONFIG_FILE = "java.util.logging.config.file";
    private final ConnectionProvider connectionProvider;
    private final String user;
    private final String password;
    private final String contentBase;
    private boolean authenticationPreemptive = false;
    private boolean challengeIgnored = false;
    private Logger logger = ContentSourceImpl.newDefaultLogger();
    private AuthType authType = AuthType.NONE;
    private String challenge;
    private static Random random = new Random();

    private static Logger newDefaultLogger() {
        LogManager logManager = LogManager.getLogManager();
        Logger logger = logManager.getLogger(DEFAULT_LOGGER_NAME);
        if (logger != null) {
            return logger;
        }
        if (System.getProperty(SYSTEM_LOGGING_CONFIG_CLASS) != null || System.getProperty(SYSTEM_LOGGING_CONFIG_FILE) != null) {
            return Logger.getLogger(DEFAULT_LOGGER_NAME);
        }
        return ContentSourceImpl.customizedLogger(logManager);
    }

    private void initializeConfig() {
        URL url = this.getClass().getClassLoader().getResource(XCC_CONFIG_FILE);
        Properties props = System.getProperties();
        if (url != null) {
            try {
                FileInputStream is = new FileInputStream(url.getPath());
                props.load(is);
            }
            catch (IOException e) {
                this.logger.log(Level.WARNING, "property file not found:" + url.getPath());
            }
        }
    }

    public ContentSourceImpl(ConnectionProvider connectionProvider, String user, String password, String contentBase) {
        this.connectionProvider = connectionProvider;
        this.user = user;
        this.password = password;
        String cbName = contentBase;
        if (cbName != null && (cbName = cbName.trim()).length() == 0) {
            cbName = null;
        }
        this.contentBase = cbName;
        this.initializeConfig();
    }

    @Override
    public ConnectionProvider getConnectionProvider() {
        return this.connectionProvider;
    }

    @Override
    public Session newSession() {
        return this.newSession(this.user, this.password);
    }

    @Override
    public Session newSession(String userName, String password) {
        return this.newSession(userName, password, null);
    }

    @Override
    public Session newSession(String user, String password, String contentBaseArg) {
        String contentBase = contentBaseArg == null ? this.contentBase : contentBaseArg;
        return new SessionImpl(this, this.connectionProvider, new Credentials(user, password), contentBase);
    }

    @Override
    public Session newSession(String databaseId) {
        return this.newSession(this.user, this.password, databaseId);
    }

    @Override
    public Logger getDefaultLogger() {
        return this.logger;
    }

    @Override
    public void setDefaultLogger(Logger logger) {
        this.logger = logger;
    }

    @Override
    public boolean isAuthenticationPreemptive() {
        return this.authenticationPreemptive;
    }

    @Override
    public void setAuthenticationPreemptive(boolean value) {
        this.authenticationPreemptive = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAuthChallenge(String challenge) {
        ContentSourceImpl contentSourceImpl = this;
        synchronized (contentSourceImpl) {
            this.authType = AuthType.valueOf(challenge.split(" ")[0].toUpperCase());
            this.challenge = challenge;
        }
    }

    public boolean isChallengeIgnored() {
        return this.challengeIgnored;
    }

    public void setChallengeIgnored(boolean challengeIgnored) {
        this.challengeIgnored = challengeIgnored;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAuthString(String method, String uri, UserCredentials credentials) {
        String challenge;
        AuthType authType;
        ContentSourceImpl contentSourceImpl = this;
        synchronized (contentSourceImpl) {
            authType = this.authType;
            challenge = this.challenge;
        }
        switch (authType) {
            case BASIC: {
                return credentials.toHttpBasicAuth();
            }
            case DIGEST: {
                return credentials.toHttpDigestAuth(method, uri, challenge);
            }
            case NEGOTIATE: {
                return credentials.toHttpNegotiateAuth(this.connectionProvider.getHostName(), challenge);
            }
        }
        return this.isAuthenticationPreemptive() ? credentials.toHttpBasicAuth() : null;
    }

    public String toString() {
        return "user=" + (this.user == null ? "{none}" : this.user) + ", cb=" + (this.contentBase == null ? "{none}" : this.contentBase) + " [provider: " + this.connectionProvider.toString() + "]";
    }

    private static Logger customizedLogger(LogManager logManager) {
        Properties props = ContentSourceImpl.loadLoggingPropertiesFromResource();
        Logger logger = Logger.getLogger(DEFAULT_LOGGER_NAME);
        List<Handler> handlers = ContentSourceImpl.getLoggerHandlers(logger, logManager, props);
        Iterator<Handler> it = handlers.iterator();
        while (it.hasNext()) {
            logger.addHandler(it.next());
        }
        boolean useParentHandlers = ContentSourceImpl.getUseParentHandlersFlag(logger, logManager, props);
        logger.setUseParentHandlers(useParentHandlers);
        logManager.addLogger(logger);
        return logger;
    }

    private static Properties loadLoggingPropertiesFromResource() {
        Properties props;
        block4: {
            props = new Properties();
            URL url = ClassLoader.getSystemResource(XCC_LOGGING_CONFIG_FILE);
            try {
                if (url != null) {
                    FileInputStream is = new FileInputStream(url.getPath());
                    props.load(is);
                    return props;
                }
                InputStream is = ContentSource.class.getResourceAsStream(XCC_LOGGING_CONFIG_FILE);
                if (is != null) {
                    props.load(is);
                }
            }
            catch (IOException e) {
                Logger logger = Logger.getLogger(DEFAULT_LOGGER_NAME);
                if (logger == null) break block4;
                logger.warning("property file not found: " + url);
            }
        }
        return props;
    }

    private static List<Handler> getLoggerHandlers(Logger logger, LogManager logManager, Properties props) {
        String propName = logger.getName() + ".handlers";
        String handlerPropVal = ContentSourceImpl.getPropertyValue(propName, logManager, props);
        if (handlerPropVal == null) {
            return new ArrayList<Handler>(0);
        }
        String[] handlerClassNames = handlerPropVal.split("\\\\s*,?\\\\s*");
        ArrayList<Handler> handlers = new ArrayList<Handler>(handlerClassNames.length);
        Level level = ContentSourceImpl.getLoggerLevel(logger, logManager, props);
        if (level != null) {
            logger.setLevel(level);
        }
        for (int i = 0; i < handlerClassNames.length; ++i) {
            try {
                Class<Handler> handlerClass = Class.forName(handlerClassNames[i]).asSubclass(Handler.class);
                Handler handler = handlerClass.newInstance();
                Formatter formatter = ContentSourceImpl.getFormatter(handler, logManager, props);
                handlers.add(handler);
                if (formatter != null) {
                    handler.setFormatter(formatter);
                }
                if (level == null) continue;
                handler.setLevel(level);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return handlers;
    }

    private static Formatter getFormatter(Handler handler, LogManager logManager, Properties props) {
        String propName = handler.getClass().getName() + ".formatter";
        String formatterClassName = ContentSourceImpl.getPropertyValue(propName, logManager, props);
        try {
            Class<Formatter> clazz = Class.forName(formatterClassName).asSubclass(Formatter.class);
            Constructor<Formatter> cons = null;
            try {
                cons = clazz.getConstructor(Properties.class, LogManager.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (cons != null) {
                return cons.newInstance(props, logManager);
            }
            return (Formatter)Class.forName(formatterClassName).newInstance();
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Level getLoggerLevel(Logger logger, LogManager logManager, Properties props) {
        String propName = logger.getName() + ".level";
        String levelName = ContentSourceImpl.getPropertyValue(propName, logManager, props);
        try {
            return Level.parse(levelName);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static boolean getUseParentHandlersFlag(Logger logger, LogManager logManager, Properties props) {
        String propName = logger.getName() + ".useParentHandlers";
        String propValue = ContentSourceImpl.getPropertyValue(propName, logManager, props);
        if (propValue == null) {
            return false;
        }
        try {
            return Boolean.valueOf(propValue);
        }
        catch (Exception e) {
            return false;
        }
    }

    private static String getPropertyValue(String propName, LogManager logManager, Properties props) {
        String propVal = props.getProperty(propName);
        if (propVal != null) {
            return propVal.trim();
        }
        propVal = logManager.getProperty(propName);
        if (propVal != null) {
            return propVal.trim();
        }
        return null;
    }

    public static String digestCalcResponse(String HA1, String nonce, String nonceCount, String cNonce, String qop, String method, String uri) {
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            StringBuilder plaintext = new StringBuilder();
            plaintext.append(method);
            plaintext.append(":");
            plaintext.append(uri);
            digest.update(plaintext.toString().getBytes(), 0, plaintext.length());
            String HA2 = IOHelper.bytesToHex(digest.digest());
            plaintext.setLength(0);
            plaintext.append(HA1);
            plaintext.append(":");
            plaintext.append(nonce);
            plaintext.append(":");
            if (qop != null) {
                plaintext.append(nonceCount);
                plaintext.append(":");
                plaintext.append(cNonce);
                plaintext.append(":");
                plaintext.append(qop);
                plaintext.append(":");
            }
            plaintext.append(HA2);
            digest.update(plaintext.toString().getBytes(), 0, plaintext.length());
            return IOHelper.bytesToHex(digest.digest());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static String digestCalcHA1(String userName, String realm, String password) {
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            StringBuilder plaintext = new StringBuilder();
            plaintext.append(userName);
            plaintext.append(":");
            plaintext.append(realm);
            plaintext.append(":");
            plaintext.append(password);
            digest.update(plaintext.toString().getBytes(), 0, plaintext.length());
            return IOHelper.bytesToHex(digest.digest());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    static class Credentials
    implements UserCredentials {
        private String user;
        private String password;
        private static final AtomicLong nonceCounter = new AtomicLong();

        public Credentials(String user, String password) {
            this.user = user;
            this.password = password;
        }

        @Override
        public String getUserName() {
            return this.user;
        }

        @Override
        public String toHttpBasicAuth() {
            if (this.user == null || this.password == null) {
                throw new IllegalStateException("Invalid authentication credentials");
            }
            try {
                return "basic " + Base64.encodeBytes((this.user + ":" + this.password).getBytes("UTF-8"), 8);
            }
            catch (UnsupportedEncodingException e) {
                return "basic " + Base64.encodeBytes((this.user + ":" + this.password).getBytes(), 8);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String toHttpDigestAuth(String method, String uri, String challengeHeader) {
            if (this.user == null || this.password == null) {
                throw new IllegalStateException("Invalid authentication credentials");
            }
            if (challengeHeader == null || !challengeHeader.startsWith("Digest ")) {
                return null;
            }
            String[] pairs = challengeHeader.substring("Digest ".length()).split(", +");
            HashMap<String, String> params = new HashMap<String, String>();
            for (String pair : pairs) {
                String[] nv = pair.split("=", 2);
                params.put(nv[0].toLowerCase(), nv[1].substring(1, nv[1].length() - 1));
            }
            String realm = (String)params.get("realm");
            String HA1 = ContentSourceImpl.digestCalcHA1(this.user, realm, this.password);
            String nonce = (String)params.get("nonce");
            String qop = (String)params.get("qop");
            String opaque = (String)params.get("opaque");
            byte[] bytes = new byte[16];
            Random random = random;
            synchronized (random) {
                random.nextBytes(bytes);
            }
            String cNonce = IOHelper.bytesToHex(bytes);
            String nonceCount = Long.toHexString(nonceCounter.incrementAndGet());
            String response = ContentSourceImpl.digestCalcResponse(HA1, nonce, nonceCount, cNonce, qop, method, uri);
            StringBuilder buf = new StringBuilder();
            buf.append("Digest username=\"");
            buf.append(this.user);
            buf.append("\", realm=\"");
            buf.append(realm);
            buf.append("\", nonce=\"");
            buf.append(nonce);
            buf.append("\", uri=\"");
            buf.append(uri);
            buf.append("\", qop=\"auth\", nc=\"");
            buf.append(nonceCount);
            buf.append("\", cnonce=\"");
            buf.append(cNonce);
            buf.append("\", response=\"");
            buf.append(response);
            buf.append("\", opaque=\"");
            buf.append(opaque);
            buf.append("\"");
            return buf.toString();
        }

        @Override
        public String toHttpNegotiateAuth(String hostName, String challenge) {
            try {
                GSSManager manager = GSSManager.getInstance();
                Oid krb5Mechanism = new Oid("1.2.840.113554.1.2.2");
                Oid krb5PrincipalNameType = new Oid("1.2.840.113554.1.2.2.1");
                GSSName serverName = manager.createName("HTTP/" + hostName, krb5PrincipalNameType);
                GSSCredential userCreds = manager.createCredential(1);
                GSSContext context = manager.createContext(serverName, krb5Mechanism, userCreds, 0);
                byte[] inToken = new byte[]{};
                String[] parts = challenge.split(" ");
                if (parts.length > 1) {
                    inToken = Base64.decode(parts[1]);
                }
                byte[] outToken = context.initSecContext(inToken, 0, inToken.length);
                String str = "Negotiate " + Base64.encodeBytes(outToken, 8);
                return str;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public String toString() {
            return "user=" + this.user;
        }
    }

    public static enum AuthType {
        NONE,
        BASIC,
        DIGEST,
        NEGOTIATE;

    }
}

