/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.xcc;

import com.marklogic.xcc.ContentSource;
import com.marklogic.xcc.SecurityOptions;
import com.marklogic.xcc.exceptions.XccConfigException;
import com.marklogic.xcc.impl.ContentSourceImpl;
import com.marklogic.xcc.impl.SSLSocketPoolProvider;
import com.marklogic.xcc.impl.SocketPoolProvider;
import com.marklogic.xcc.spi.ConnectionProvider;
import java.net.InetSocketAddress;
import java.net.URI;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ContentSourceFactory {
    static final long GC_INTERVAL = Integer.parseInt(System.getProperty("xcc.gcinterval", "10000"));
    private static final String[] knownSchemes = new String[]{"xcc", "xccs", "xdbc"};
    private static final String[] secureSchemes = new String[]{"xccs"};
    private static final int STANDARD_PROVIDER_CACHE_SIZE = Integer.getInteger("xcc.connectionprovider.standard.cache.size", 8);
    private static final int SECURE_PROVIDER_CACHE_SIZE = Integer.getInteger("xcc.connectionprovider.secure.cache.size", 8);
    private static final Map<Object, ConnectionProvider> standardProviders = new ConcurrentHashMap<Object, ConnectionProvider>(STANDARD_PROVIDER_CACHE_SIZE);
    private static final Map<Object, ConnectionProvider> secureProviders = new ConcurrentHashMap<Object, ConnectionProvider>(SECURE_PROVIDER_CACHE_SIZE);
    private static final ConnectionCollector gc = new ConnectionCollector();

    private ContentSourceFactory() {
    }

    public static ContentSource newContentSource(ConnectionProvider connectionProvider, String user, String password, String contentbaseName) {
        return new ContentSourceImpl(connectionProvider, user, password, contentbaseName);
    }

    public static ContentSource newContentSource(URI uri, SecurityOptions options) throws XccConfigException {
        String scheme = uri.getScheme();
        String host = uri.getHost();
        int port = uri.getPort();
        String userInfoStr = uri.getUserInfo();
        String[] userInfo = userInfoStr == null ? new String[]{} : userInfoStr.split(":", 2);
        String contentBase = uri.getPath();
        if (!ContentSourceFactory.validScheme(scheme)) {
            throw new XccConfigException("Unrecognized connection scheme: " + scheme);
        }
        if (!ContentSourceFactory.secureScheme(scheme) && options != null) {
            throw new XccConfigException("Non-Secure connection requested but SecurityOptions is non-null");
        }
        if (contentBase != null) {
            if (contentBase.startsWith("/")) {
                contentBase = contentBase.substring(1);
            }
            if (contentBase.length() == 0 && (contentBase = uri.getFragment()) != null) {
                contentBase = "#" + contentBase;
            }
        }
        if (userInfo.length != 2 || userInfo[0].length() == 0 || userInfo[1].length() == 0) {
            return ContentSourceFactory.newContentSource(host, port, null, null, contentBase, options);
        }
        return ContentSourceFactory.newContentSource(host, port, userInfo[0], userInfo[1], contentBase, options);
    }

    public static ContentSource newContentSource(URI uri) throws XccConfigException {
        return ContentSourceFactory.newContentSource(uri, null);
    }

    public static ContentSource newContentSource(String host, int port, String user, String password, String contentbaseName, SecurityOptions options) {
        return ContentSourceFactory.newContentSource(options == null ? ContentSourceFactory.defaultConnectionProvider(host, port) : ContentSourceFactory.defaultSecureConnectionProvider(host, port, options), user, password, contentbaseName);
    }

    public static ContentSource newContentSource(String host, int port, String user, String password, String contentbaseName) {
        return ContentSourceFactory.newContentSource(host, port, user, password, contentbaseName, null);
    }

    public static ContentSource newContentSource(String host, int port, String user, String password) {
        return ContentSourceFactory.newContentSource(host, port, user, password, null);
    }

    public static ContentSource newContentSource(String host, int port) {
        return ContentSourceFactory.newContentSource(host, port, null, null, null);
    }

    static ConnectionProvider defaultConnectionProvider(String host, int port) {
        InetSocketAddress address = new InetSocketAddress(host, port);
        if (address.isUnresolved()) {
            throw new IllegalArgumentException("Default provider - Not a usable net address: " + address);
        }
        ConnectionProvider provider = standardProviders.get(address);
        if (provider == null) {
            provider = new SocketPoolProvider(address);
            standardProviders.put(address, provider);
        }
        gc.checkAlive();
        return provider;
    }

    private static ConnectionProvider defaultSecureConnectionProvider(String host, int port, SecurityOptions options) {
        final InetSocketAddress address = new InetSocketAddress(host, port);
        if (address.isUnresolved()) {
            throw new IllegalArgumentException("Default secure provider - Not a usable net address: " + address);
        }
        final SecurityOptions securityOptions = new SecurityOptions(options);
        class Key {
            Key() {
            }

            public InetSocketAddress getAddress() {
                return address;
            }

            public SecurityOptions getSecurityOptions() {
                return securityOptions;
            }

            public int hashCode() {
                return address.hashCode() + securityOptions.hashCode();
            }

            public boolean equals(Object o) {
                if (o instanceof Key) {
                    Key k = (Key)o;
                    return this == k || address.equals(k.getAddress()) && securityOptions.equals(k.getSecurityOptions());
                }
                return false;
            }
        }
        Key key = new Key();
        ConnectionProvider provider = secureProviders.get(key);
        if (provider == null) {
            try {
                provider = new SSLSocketPoolProvider(address, securityOptions);
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
            catch (KeyManagementException e) {
                e.printStackTrace();
            }
            secureProviders.put(key, provider);
        }
        gc.checkAlive();
        return provider;
    }

    private static boolean validScheme(String scheme) {
        if (scheme == null) {
            return false;
        }
        for (int i = 0; i < knownSchemes.length; ++i) {
            if (!scheme.equalsIgnoreCase(knownSchemes[i])) continue;
            return true;
        }
        return false;
    }

    private static boolean secureScheme(String scheme) {
        if (scheme == null) {
            return false;
        }
        for (int i = 0; i < secureSchemes.length; ++i) {
            if (!scheme.equalsIgnoreCase(secureSchemes[i])) continue;
            return true;
        }
        return false;
    }

    static class ConnectionCollector
    extends Thread {
        ConnectionCollector() {
        }

        @Override
        public void run() {
            block2: while (true) {
                try {
                    Thread.sleep(GC_INTERVAL);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                long currTime = System.currentTimeMillis();
                for (ConnectionProvider pool : standardProviders.values()) {
                    pool.closeExpired(currTime);
                }
                Iterator iterator = secureProviders.values().iterator();
                while (true) {
                    ConnectionProvider pool;
                    if (!iterator.hasNext()) continue block2;
                    pool = (ConnectionProvider)iterator.next();
                    pool.closeExpired(currTime);
                }
                break;
            }
        }

        public synchronized void checkAlive() {
            if (!this.isAlive()) {
                this.setDaemon(true);
                try {
                    this.setPriority(1);
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                this.start();
            }
        }
    }
}

