/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.xcc.types.impl;

import com.marklogic.xcc.types.ValueType;
import com.marklogic.xcc.types.VecVector;
import com.marklogic.xcc.types.impl.AbstractStringItem;

public class VecVectorImpl
extends AbstractStringItem
implements VecVector {
    private final float[] values;

    public VecVectorImpl(String value) throws IllegalArgumentException {
        super(ValueType.VEC_VECTOR, value);
        if (value == null) {
            throw new IllegalArgumentException("Value string must not be null.");
        }
        if (value.isEmpty()) {
            throw new IllegalArgumentException("Value string must not be empty.");
        }
        if (!VecVectorImpl.isVectorFormat(value)) {
            VecVectorImpl.throwVectorFormatError();
        }
        this.values = VecVectorImpl.parseVectorString(value);
    }

    public VecVectorImpl(float[] values) throws IllegalArgumentException {
        super(ValueType.VEC_VECTOR, null);
        if (values == null) {
            throw new IllegalArgumentException("Array must not be null.");
        }
        if (values.length < 1) {
            throw new IllegalArgumentException("Array must not be empty.");
        }
        this.values = values;
    }

    private static boolean isVectorFormat(String str) {
        return str.charAt(0) == '[' && str.charAt(str.length() - 1) == ']';
    }

    private static void throwVectorFormatError() throws IllegalArgumentException {
        throw new IllegalArgumentException("Value string must be in vector format. Example: [ x, y, z ]");
    }

    private static void throwNumberFormatAtIndexError(String val, int index) throws NumberFormatException {
        throw new NumberFormatException("Value [" + val + "] at index [" + index + "] can not be parsed");
    }

    private static float[] parseVectorString(String vectorString) throws IllegalArgumentException {
        int valueCount = VecVectorImpl.countCommas(vectorString) + 1;
        float[] result = new float[valueCount];
        StringBuilder input = new StringBuilder();
        int arrayIndex = 0;
        block8: for (int i = 1; i < vectorString.length(); ++i) {
            char c = vectorString.charAt(i);
            switch (c) {
                case '[': {
                    VecVectorImpl.throwVectorFormatError();
                }
                case ' ': {
                    continue block8;
                }
                case ']': {
                    if (i != vectorString.length() - 1) {
                        VecVectorImpl.throwVectorFormatError();
                    }
                }
                case ',': {
                    String val = input.toString();
                    if (val.isEmpty()) {
                        throw new IllegalArgumentException("Value missing at index [" + arrayIndex + "]");
                    }
                    try {
                        result[arrayIndex] = Float.parseFloat(val);
                    }
                    catch (NumberFormatException e) {
                        VecVectorImpl.throwNumberFormatAtIndexError(val, arrayIndex);
                    }
                    ++arrayIndex;
                    input.setLength(0);
                    continue block8;
                }
                default: {
                    input.append(c);
                }
            }
        }
        return result;
    }

    private static int countCommas(String str) {
        int result = 0;
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) != ',') continue;
            ++result;
        }
        return result;
    }

    @Override
    public String asString() {
        if (this.value == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("[ ");
            float[] fArray = this.values;
            int n = fArray.length;
            for (int i = 0; i < n; ++i) {
                Float v = Float.valueOf(fArray[i]);
                sb.append(v.floatValue());
                sb.append(", ");
            }
            this.value = sb.substring(0, sb.length() - 2) + " ]";
        }
        return this.value;
    }

    @Override
    public float[] getValues() {
        return this.values;
    }
}

