/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.xcc.impl;

import com.marklogic.xcc.AdhocQuery;
import com.marklogic.xcc.ContentSource;
import com.marklogic.xcc.Session;
import com.marklogic.xcc.exceptions.RequestException;
import com.marklogic.xcc.impl.handlers.PDCloudRequestController;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class PDCloudAuthManager {
    private static final long RENEW_OFFSET_MINUTES = 1L;
    private static final Logger logger;
    private static final ScheduledExecutorService scheduler;
    private static final ConcurrentHashMap<Integer, PDCloudAuthContext> contextMap;

    private PDCloudAuthManager() {
    }

    public static synchronized void createPDCloudAuthContext(ContentSource cs) {
        int apiKeyHash = new String(cs.getUserCredentials().getPDCloudAuthConfig().getApiKey()).hashCode();
        if (!contextMap.containsKey(apiKeyHash)) {
            contextMap.put(apiKeyHash, new PDCloudAuthContext(cs));
            PDCloudAuthManager.runObtainSessionTokenOneTime(apiKeyHash);
            PDCloudAuthManager.runRenewSessionToken(apiKeyHash);
        }
    }

    private static void runObtainSessionTokenOneTime(int hash) {
        block4: {
            PDCloudAuthContext context = contextMap.get(hash);
            if (context != null && context.tokenConfig != null && !context.tokenToExpire()) {
                return;
            }
            if (logger.isLoggable(Level.INFO)) {
                logger.log(Level.INFO, "Scheduled to obtain session token one time.");
            }
            ScheduledFuture<?> handle = scheduler.schedule(new TokenRunner(hash), 0L, TimeUnit.MINUTES);
            try {
                handle.get();
            }
            catch (InterruptedException | ExecutionException e) {
                if (!logger.isLoggable(Level.WARNING)) break block4;
                logger.log(Level.WARNING, "Exception obtaining session token from MarkLogic Cloud token endpoint. " + e.getMessage());
            }
        }
    }

    private static void runRenewSessionToken(int hash) {
        PDCloudAuthContext context = contextMap.get(hash);
        if (context != null && context.tokenConfig != null) {
            long initDelay = context.getInitDelay();
            long period = context.getPeriod();
            if (logger.isLoggable(Level.INFO)) {
                logger.log(Level.INFO, "Scheduled to renew session token periodically. initDelay=" + initDelay + " minutes, period=" + period + " minutes.");
            }
            scheduler.scheduleWithFixedDelay(new TokenRunner(hash), initDelay, period, TimeUnit.MINUTES);
        }
    }

    public static void setTokenConfig(char[] apiKey, char[] curToken, long tokenExpiration, long tokenDuration) {
        int hash = new String(apiKey).hashCode();
        PDCloudAuthContext context = contextMap.get(hash);
        if (context != null) {
            context.setTokenConfig(curToken, tokenExpiration, tokenDuration);
        }
    }

    public static String getSessionToken(char[] apiKey) {
        int hash = new String(apiKey).hashCode();
        PDCloudAuthContext context = contextMap.get(hash);
        if (context != null && context.tokenConfig != null) {
            return new String(context.tokenConfig.curToken);
        }
        return null;
    }

    public static long getTokenExpiration(char[] apiKey) {
        int hash = new String(apiKey).hashCode();
        PDCloudAuthContext context = contextMap.get(hash);
        if (context != null && context.tokenConfig != null) {
            return context.tokenConfig.tokenExpiration;
        }
        return 0L;
    }

    public static long getTokenDuration(char[] apiKey) {
        int hash = new String(apiKey).hashCode();
        PDCloudAuthContext context = contextMap.get(hash);
        if (context != null && context.tokenConfig != null) {
            return context.tokenConfig.tokenDuration;
        }
        return 0L;
    }

    static {
        contextMap = new ConcurrentHashMap();
        logger = Logger.getLogger(PDCloudAuthManager.class.getName());
        scheduler = Executors.newScheduledThreadPool(1, r -> {
            Thread t = new Thread(r);
            t.setDaemon(true);
            t.setPriority(10);
            return t;
        });
    }

    private static class TokenRunner
    implements Runnable {
        private final int apiKeyHash;

        public TokenRunner(int apiKeyHash) {
            this.apiKeyHash = apiKeyHash;
        }

        @Override
        public void run() {
            PDCloudAuthContext context = (PDCloudAuthContext)contextMap.get(this.apiKeyHash);
            if (context == null) {
                throw new RuntimeException("Unrecognized user api key.");
            }
            if (logger.isLoggable(Level.INFO)) {
                logger.log(Level.INFO, "Connecting to MarkLogic Cloud to obtain session token.");
            }
            Session session = context.cs.newSession();
            AdhocQuery request = session.newAdhocQuery("()");
            PDCloudRequestController controller = new PDCloudRequestController(session.getUserCredentials().getPDCloudAuthConfig());
            try {
                controller.runRequest(session.getContentSource().getConnectionProvider(), request, session.getLogger());
            }
            catch (RequestException e) {
                throw new RuntimeException("Exception obtaining session token.", e);
            }
        }
    }

    private static class PDCloudAuthContext {
        private final ContentSource cs;
        private TokenConfig tokenConfig;

        private PDCloudAuthContext(ContentSource cs) {
            this.cs = cs;
        }

        private void setTokenConfig(char[] curToken, long tokenExpiration, long tokenDuration) {
            this.tokenConfig = new TokenConfig(curToken, tokenExpiration, tokenDuration);
        }

        private long getInitDelay() {
            return TimeUnit.MILLISECONDS.toMinutes(this.tokenConfig.tokenExpiration - System.currentTimeMillis()) - 1L;
        }

        private long getPeriod() {
            return this.tokenConfig.tokenDuration - 1L;
        }

        private boolean tokenToExpire() {
            return TimeUnit.MILLISECONDS.toMinutes(this.tokenConfig.tokenExpiration - System.currentTimeMillis()) - 1L <= 0L;
        }

        private static class TokenConfig {
            private final char[] curToken;
            private final long tokenExpiration;
            private final long tokenDuration;

            private TokenConfig(char[] curToken, long tokenExpiration, long tokenDuration) {
                this.curToken = curToken;
                this.tokenExpiration = tokenExpiration;
                this.tokenDuration = tokenDuration;
            }
        }
    }
}

