/*
 * Copyright (c) 2006-2020 Progress Software Corporation and/or its subsidiaries or affiliates. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.marklogic.xcc.types;

import java.io.IOException;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;

import org.xml.sax.SAXException;

/**
 * An XQuery value which is a processing-instruction().
 */
public interface XdmProcessingInstruction extends XdmNode {
    
    public org.w3c.dom.ProcessingInstruction asW3cProcessingInstruction(DocumentBuilder docBuilder) throws IOException, SAXException;

    public org.w3c.dom.ProcessingInstruction asW3cProcessingInstruction() throws ParserConfigurationException, IOException, SAXException;
}
