/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.api.staticmap.v1.models;

import androidx.annotation.FloatRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.google.auto.value.AutoValue;
import com.mapbox.api.staticmap.v1.models.AutoValue_StaticPolylineAnnotation;
import com.mapbox.core.utils.ColorUtils;

@AutoValue
public abstract class StaticPolylineAnnotation {
    public static Builder builder() {
        return new AutoValue_StaticPolylineAnnotation.Builder();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public String url() {
        StringBuilder sb = new StringBuilder();
        sb.append("path");
        if (this.strokeWidth() != null) {
            sb.append("-").append(this.strokeWidth());
        }
        if (this.strokeColor() != null) {
            sb.append("+").append(this.strokeColor());
        }
        if (this.strokeOpacity() != null) {
            sb.append("-").append(this.strokeOpacity());
        }
        if (this.fillColor() != null) {
            sb.append("+").append(this.fillColor());
        }
        if (this.fillOpacity() != null) {
            sb.append("-").append(this.fillOpacity());
        }
        sb.append("(").append(this.polyline()).append(")");
        return sb.toString();
    }

    @Nullable
    abstract Double strokeWidth();

    @Nullable
    abstract String strokeColor();

    @Nullable
    abstract Float strokeOpacity();

    @Nullable
    abstract String fillColor();

    @Nullable
    abstract Float fillOpacity();

    @NonNull
    abstract String polyline();

    public abstract Builder toBuilder();

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder strokeWidth(@Nullable @FloatRange(from=0.0) Double var1);

        public abstract Builder strokeColor(@Nullable String var1);

        public Builder strokeColor(int red, int green, int blue) {
            return this.strokeColor(ColorUtils.toHexString((int)red, (int)green, (int)blue));
        }

        public abstract Builder strokeOpacity(@Nullable @FloatRange(from=0.0, to=1.0) Float var1);

        public abstract Builder fillColor(@Nullable String var1);

        public Builder fillColor(int red, int green, int blue) {
            return this.fillColor(ColorUtils.toHexString((int)red, (int)green, (int)blue));
        }

        public abstract Builder fillOpacity(@Nullable @FloatRange(from=0.0, to=1.0) Float var1);

        public abstract Builder polyline(@NonNull String var1);

        public abstract StaticPolylineAnnotation build();
    }
}

