/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.api.routetiles.v1;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.auto.value.AutoValue;
import com.mapbox.api.routetiles.v1.AutoValue_MapboxRouteTiles;
import com.mapbox.api.routetiles.v1.RouteTilesService;
import com.mapbox.core.MapboxService;
import com.mapbox.core.exceptions.ServicesException;
import com.mapbox.core.utils.ApiCallHelper;
import com.mapbox.core.utils.MapboxUtils;
import com.mapbox.geojson.BoundingBox;
import java.util.Locale;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.ResponseBody;
import okhttp3.logging.HttpLoggingInterceptor;
import retrofit2.Call;

@AutoValue
public abstract class MapboxRouteTiles
extends MapboxService<ResponseBody, RouteTilesService> {
    protected MapboxRouteTiles() {
        super(RouteTilesService.class);
    }

    protected Call<ResponseBody> initializeCall() {
        return ((RouteTilesService)this.getService()).getCall(ApiCallHelper.getHeaderUserAgent((String)this.clientAppName()), this.formatBoundingBox(this.boundingBox()), this.version(), this.accessToken());
    }

    protected synchronized OkHttpClient getOkHttpClient() {
        if (this.okHttpClient == null) {
            Interceptor networkInterceptor;
            Interceptor interceptor;
            OkHttpClient.Builder httpClient = new OkHttpClient.Builder();
            if (this.isEnableDebug()) {
                HttpLoggingInterceptor logging = new HttpLoggingInterceptor();
                logging.setLevel(HttpLoggingInterceptor.Level.BASIC);
                httpClient.addInterceptor((Interceptor)logging);
            }
            if ((interceptor = this.interceptor()) != null) {
                httpClient.addInterceptor(interceptor);
            }
            if ((networkInterceptor = this.networkInterceptor()) != null) {
                httpClient.addNetworkInterceptor(networkInterceptor);
            }
            this.okHttpClient = httpClient.build();
        }
        return this.okHttpClient;
    }

    @Nullable
    abstract String clientAppName();

    @NonNull
    abstract BoundingBox boundingBox();

    @NonNull
    abstract String version();

    @NonNull
    abstract String accessToken();

    @Nullable
    abstract Interceptor interceptor();

    @Nullable
    abstract Interceptor networkInterceptor();

    protected abstract String baseUrl();

    public static Builder builder() {
        return new AutoValue_MapboxRouteTiles.Builder().baseUrl("https://api.mapbox.com");
    }

    public abstract Builder toBuilder();

    private String formatBoundingBox(BoundingBox boundingBox) {
        return String.format(Locale.US, "%f,%f;%f,%f", boundingBox.west(), boundingBox.south(), boundingBox.east(), boundingBox.north());
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder boundingBox(@NonNull BoundingBox var1);

        public abstract Builder version(@NonNull String var1);

        public abstract Builder accessToken(@NonNull String var1);

        public abstract Builder baseUrl(@NonNull String var1);

        public abstract Builder clientAppName(@NonNull String var1);

        public abstract Builder interceptor(Interceptor var1);

        public abstract Builder networkInterceptor(Interceptor var1);

        abstract MapboxRouteTiles autoBuild();

        public MapboxRouteTiles build() {
            MapboxRouteTiles mapboxRouteTiles = this.autoBuild();
            if (!MapboxUtils.isAccessTokenValid((String)mapboxRouteTiles.accessToken())) {
                throw new ServicesException("Using Mapbox Services requires setting a valid access token.");
            }
            return mapboxRouteTiles;
        }
    }
}

