/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.api.matching.v5;

import com.mapbox.api.directions.v5.models.RouteOptions;
import com.mapbox.api.directions.v5.utils.ParseUtils;
import com.mapbox.api.matching.v5.MapboxMapMatching;
import com.mapbox.api.matching.v5.models.MapMatchingMatching;
import com.mapbox.api.matching.v5.models.MapMatchingResponse;
import com.mapbox.geojson.Point;
import java.util.ArrayList;
import java.util.List;
import okhttp3.Response;

class MatchingResponseFactory {
    private static final String PLACEHOLDER_UUID = "mapmatching";
    private final MapboxMapMatching mapboxMapMatching;

    MatchingResponseFactory(MapboxMapMatching mapboxMapMatching) {
        this.mapboxMapMatching = mapboxMapMatching;
    }

    retrofit2.Response<MapMatchingResponse> generate(retrofit2.Response<MapMatchingResponse> response) {
        if (this.isNotSuccessful(response)) {
            return response;
        }
        return retrofit2.Response.success((Object)((MapMatchingResponse)response.body()).toBuilder().matchings(this.generateRouteOptions(response)).build(), (Response)new Response.Builder().code(200).message("OK").protocol(response.raw().protocol()).headers(response.headers()).request(response.raw().request()).build());
    }

    private boolean isNotSuccessful(retrofit2.Response<MapMatchingResponse> response) {
        return !response.isSuccessful() || response.body() == null || ((MapMatchingResponse)response.body()).matchings() == null || ((MapMatchingResponse)response.body()).matchings().isEmpty();
    }

    private List<MapMatchingMatching> generateRouteOptions(retrofit2.Response<MapMatchingResponse> response) {
        List<MapMatchingMatching> matchings = ((MapMatchingResponse)response.body()).matchings();
        ArrayList<MapMatchingMatching> modifiedMatchings = new ArrayList<MapMatchingMatching>();
        for (MapMatchingMatching matching : matchings) {
            modifiedMatchings.add(matching.toBuilder().routeOptions(RouteOptions.builder().profile(this.mapboxMapMatching.profile()).coordinates(MatchingResponseFactory.formatCoordinates(this.mapboxMapMatching.coordinates())).annotations(this.mapboxMapMatching.annotations()).approachesList(ParseUtils.parseToStrings((String)this.mapboxMapMatching.approaches())).language(this.mapboxMapMatching.language()).radiusesList(ParseUtils.parseToDoubles((String)this.mapboxMapMatching.radiuses())).user(this.mapboxMapMatching.user()).voiceInstructions(this.mapboxMapMatching.voiceInstructions()).bannerInstructions(this.mapboxMapMatching.bannerInstructions()).roundaboutExits(this.mapboxMapMatching.roundaboutExits()).geometries(this.mapboxMapMatching.geometries()).overview(this.mapboxMapMatching.overview()).steps(this.mapboxMapMatching.steps()).voiceUnits(this.mapboxMapMatching.voiceUnits()).requestUuid(PLACEHOLDER_UUID).accessToken(this.mapboxMapMatching.accessToken()).waypointIndicesList(ParseUtils.parseToIntegers((String)this.mapboxMapMatching.waypointIndices())).waypointNamesList(ParseUtils.parseToStrings((String)this.mapboxMapMatching.waypointNames())).baseUrl(this.mapboxMapMatching.baseUrl()).build()).build());
        }
        return modifiedMatchings;
    }

    private static List<Point> formatCoordinates(String coordinates) {
        String[] coordPairs = coordinates.split(";", -1);
        ArrayList<Point> coordinatesFormatted = new ArrayList<Point>();
        for (String coordPair : coordPairs) {
            String[] coords = coordPair.split(",", -1);
            coordinatesFormatted.add(Point.fromLngLat((double)Double.valueOf(coords[0]), (double)Double.valueOf(coords[1])));
        }
        return coordinatesFormatted;
    }
}

