/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.api.directions.v5;

import androidx.annotation.FloatRange;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.auto.value.AutoValue;
import com.google.gson.GsonBuilder;
import com.mapbox.api.directions.v5.AutoValue_MapboxDirections;
import com.mapbox.api.directions.v5.DirectionsAdapterFactory;
import com.mapbox.api.directions.v5.DirectionsResponseFactory;
import com.mapbox.api.directions.v5.DirectionsService;
import com.mapbox.api.directions.v5.WalkingOptions;
import com.mapbox.api.directions.v5.models.DirectionsResponse;
import com.mapbox.api.directions.v5.utils.FormatUtils;
import com.mapbox.core.MapboxService;
import com.mapbox.core.exceptions.ServicesException;
import com.mapbox.core.utils.ApiCallHelper;
import com.mapbox.core.utils.MapboxUtils;
import com.mapbox.geojson.Point;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import okhttp3.EventListener;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

@AutoValue
public abstract class MapboxDirections
extends MapboxService<DirectionsResponse, DirectionsService> {
    protected MapboxDirections() {
        super(DirectionsService.class);
    }

    protected Call<DirectionsResponse> initializeCall() {
        if (this.usePostMethod() == null) {
            return this.callForUrlLength();
        }
        if (this.usePostMethod().booleanValue()) {
            return this.post();
        }
        return this.get();
    }

    private Call<DirectionsResponse> callForUrlLength() {
        Call<DirectionsResponse> get = this.get();
        if (get.request().url().toString().length() < 8192) {
            return get;
        }
        return this.post();
    }

    private Call<DirectionsResponse> get() {
        return ((DirectionsService)this.getService()).getCall(ApiCallHelper.getHeaderUserAgent((String)this.clientAppName()), this.user(), this.profile(), FormatUtils.formatCoordinates(this.coordinates()), this.accessToken(), this.alternatives(), this.geometries(), this.overview(), this.radius(), this.steps(), this.bearing(), this.continueStraight(), this.annotation(), this.language(), this.roundaboutExits(), this.voiceInstructions(), this.bannerInstructions(), this.voiceUnits(), this.exclude(), this.approaches(), this.waypointIndices(), this.waypointNames(), this.waypointTargets(), this.enableRefresh(), this.walkingSpeed(), this.walkwayBias(), this.alleyBias());
    }

    private Call<DirectionsResponse> post() {
        return ((DirectionsService)this.getService()).postCall(ApiCallHelper.getHeaderUserAgent((String)this.clientAppName()), this.user(), this.profile(), FormatUtils.formatCoordinates(this.coordinates()), this.accessToken(), this.alternatives(), this.geometries(), this.overview(), this.radius(), this.steps(), this.bearing(), this.continueStraight(), this.annotation(), this.language(), this.roundaboutExits(), this.voiceInstructions(), this.bannerInstructions(), this.voiceUnits(), this.exclude(), this.approaches(), this.waypointIndices(), this.waypointNames(), this.waypointTargets(), this.enableRefresh(), this.walkingSpeed(), this.walkwayBias(), this.alleyBias());
    }

    protected GsonBuilder getGsonBuilder() {
        return super.getGsonBuilder().registerTypeAdapterFactory(DirectionsAdapterFactory.create());
    }

    public Response<DirectionsResponse> executeCall() throws IOException {
        Response response = super.executeCall();
        DirectionsResponseFactory factory = new DirectionsResponseFactory(this);
        return factory.generate((Response<DirectionsResponse>)response);
    }

    public void enqueueCall(final Callback<DirectionsResponse> callback) {
        this.getCall().enqueue((Callback)new Callback<DirectionsResponse>(){

            public void onResponse(Call<DirectionsResponse> call, Response<DirectionsResponse> response) {
                DirectionsResponseFactory factory = new DirectionsResponseFactory(MapboxDirections.this);
                Response<DirectionsResponse> generatedResponse = factory.generate(response);
                callback.onResponse(call, generatedResponse);
            }

            public void onFailure(Call<DirectionsResponse> call, Throwable throwable) {
                callback.onFailure(call, throwable);
            }
        });
    }

    protected synchronized OkHttpClient getOkHttpClient() {
        if (this.okHttpClient == null) {
            EventListener eventListener;
            Interceptor networkInterceptor;
            Interceptor interceptor;
            OkHttpClient.Builder httpClient = new OkHttpClient.Builder();
            if (this.isEnableDebug()) {
                HttpLoggingInterceptor logging = new HttpLoggingInterceptor();
                logging.setLevel(HttpLoggingInterceptor.Level.BASIC);
                httpClient.addInterceptor((Interceptor)logging);
            }
            if ((interceptor = this.interceptor()) != null) {
                httpClient.addInterceptor(interceptor);
            }
            if ((networkInterceptor = this.networkInterceptor()) != null) {
                httpClient.addNetworkInterceptor(networkInterceptor);
            }
            if ((eventListener = this.eventListener()) != null) {
                httpClient.eventListener(eventListener);
            }
            this.okHttpClient = httpClient.build();
        }
        return this.okHttpClient;
    }

    @NonNull
    abstract String user();

    @NonNull
    abstract String profile();

    @NonNull
    abstract List<Point> coordinates();

    @NonNull
    protected abstract String baseUrl();

    @NonNull
    abstract String accessToken();

    @Nullable
    abstract Boolean alternatives();

    @Nullable
    abstract String geometries();

    @Nullable
    abstract String overview();

    @Nullable
    abstract String radius();

    @Nullable
    abstract String bearing();

    @Nullable
    abstract Boolean steps();

    @Nullable
    abstract Boolean continueStraight();

    @Nullable
    abstract String annotation();

    @Nullable
    abstract String language();

    @Nullable
    abstract Boolean roundaboutExits();

    @Nullable
    abstract String clientAppName();

    @Nullable
    abstract Boolean voiceInstructions();

    @Nullable
    abstract Boolean bannerInstructions();

    @Nullable
    abstract String voiceUnits();

    @Nullable
    abstract String exclude();

    @Nullable
    abstract String approaches();

    @Nullable
    abstract String waypointIndices();

    @Nullable
    abstract String waypointNames();

    @Nullable
    abstract String waypointTargets();

    @Nullable
    abstract Boolean enableRefresh();

    @Nullable
    abstract Interceptor interceptor();

    @Nullable
    abstract Interceptor networkInterceptor();

    @Nullable
    abstract EventListener eventListener();

    @Nullable
    abstract Boolean usePostMethod();

    @Nullable
    abstract WalkingOptions walkingOptions();

    @Nullable
    Double walkingSpeed() {
        if (!this.hasWalkingOptions()) {
            return null;
        }
        return this.walkingOptions().walkingSpeed();
    }

    @Nullable
    Double walkwayBias() {
        if (!this.hasWalkingOptions()) {
            return null;
        }
        return this.walkingOptions().walkwayBias();
    }

    @Nullable
    Double alleyBias() {
        if (!this.hasWalkingOptions()) {
            return null;
        }
        return this.walkingOptions().alleyBias();
    }

    private boolean hasWalkingOptions() {
        return this.walkingOptions() != null;
    }

    public static Builder builder() {
        return new AutoValue_MapboxDirections.Builder().baseUrl("https://api.mapbox.com").profile("driving").user("mapbox").geometries("polyline6");
    }

    public abstract Builder toBuilder();

    @AutoValue.Builder
    public static abstract class Builder {
        private List<List<Double>> bearings = new ArrayList<List<Double>>();
        private List<Point> coordinates = new ArrayList<Point>();
        private List<String> annotations = new ArrayList<String>();
        private List<Double> radiuses = new ArrayList<Double>();
        private Point destination;
        private Point origin;
        private List<String> approaches = new ArrayList<String>();
        private List<Integer> waypointIndices = new ArrayList<Integer>();
        private List<String> waypointNames = new ArrayList<String>();
        private List<Point> waypointTargets = new ArrayList<Point>();

        public abstract Builder user(@NonNull String var1);

        public abstract Builder profile(@NonNull String var1);

        public Builder origin(@NonNull Point origin) {
            this.origin = origin;
            return this;
        }

        public Builder destination(@NonNull Point destination) {
            this.destination = destination;
            return this;
        }

        public Builder addWaypoint(@NonNull Point waypoint) {
            this.coordinates.add(waypoint);
            return this;
        }

        public Builder waypoints(@NonNull List<Point> waypoints) {
            this.coordinates = waypoints;
            return this;
        }

        public abstract Builder alternatives(@Nullable Boolean var1);

        public abstract Builder geometries(String var1);

        public abstract Builder overview(@Nullable String var1);

        public abstract Builder steps(@Nullable Boolean var1);

        public abstract Builder continueStraight(@Nullable Boolean var1);

        public Builder language(@Nullable Locale language) {
            if (language != null) {
                this.language(language.getLanguage());
            }
            return this;
        }

        abstract Builder language(@Nullable String var1);

        public abstract Builder roundaboutExits(@Nullable Boolean var1);

        @Deprecated
        public Builder annotations(String ... annotations) {
            return this.annotations(Arrays.asList(annotations));
        }

        public Builder annotations(@NonNull List<String> annotations) {
            this.annotations = annotations;
            return this;
        }

        public Builder addAnnotation(@NonNull String annotation) {
            this.annotations.add(annotation);
            return this;
        }

        abstract Builder annotation(@Nullable String var1);

        public Builder addBearing(@Nullable @FloatRange(from=0.0, to=360.0) Double angle, @Nullable @FloatRange(from=0.0, to=360.0) Double tolerance) {
            this.bearings.add(Arrays.asList(angle, tolerance));
            return this;
        }

        public Builder bearings(@NonNull List<List<Double>> bearings) {
            this.bearings = bearings;
            return this;
        }

        abstract Builder bearing(@Nullable String var1);

        @Deprecated
        public Builder radiuses(Double ... radiuses) {
            return this.radiuses(Arrays.asList(radiuses));
        }

        public Builder radiuses(@NonNull List<Double> radiuses) {
            this.radiuses = radiuses;
            return this;
        }

        public Builder addRadius(@NonNull @FloatRange(from=0.0) Double radius) {
            this.radiuses.add(radius);
            return this;
        }

        abstract Builder radius(@Nullable String var1);

        public abstract Builder exclude(String var1);

        public abstract Builder voiceInstructions(@Nullable Boolean var1);

        public abstract Builder bannerInstructions(@Nullable Boolean var1);

        public abstract Builder voiceUnits(@Nullable String var1);

        public abstract Builder clientAppName(@NonNull String var1);

        public abstract Builder accessToken(@NonNull String var1);

        public abstract Builder baseUrl(String var1);

        public abstract Builder interceptor(Interceptor var1);

        public abstract Builder networkInterceptor(Interceptor var1);

        public abstract Builder eventListener(EventListener var1);

        abstract Builder coordinates(@NonNull List<Point> var1);

        @Deprecated
        public Builder addApproaches(String ... approaches) {
            return this.approaches(Arrays.asList(approaches));
        }

        public Builder approaches(@NonNull List<String> approaches) {
            this.approaches = approaches;
            return this;
        }

        abstract Builder approaches(@Nullable String var1);

        public Builder addApproach(@Nullable String approach) {
            this.approaches.add(approach);
            return this;
        }

        @Deprecated
        public Builder addWaypointIndices(Integer ... waypointIndices) {
            return this.waypointIndices(Arrays.asList(waypointIndices));
        }

        public Builder waypointIndices(@NonNull List<Integer> waypointIndices) {
            this.waypointIndices = waypointIndices;
            return this;
        }

        abstract Builder waypointIndices(@Nullable String var1);

        public Builder addWaypointIndex(@NonNull @IntRange(from=0L) Integer waypointIndex) {
            this.waypointIndices.add(waypointIndex);
            return this;
        }

        @Deprecated
        public Builder addWaypointNames(String ... waypointNames) {
            return this.waypointNames(Arrays.asList(waypointNames));
        }

        public Builder waypointNames(@NonNull List<String> waypointNames) {
            this.waypointNames = waypointNames;
            return this;
        }

        abstract Builder waypointNames(@Nullable String var1);

        public Builder addWaypointName(@Nullable String waypointName) {
            this.waypointNames.add(waypointName);
            return this;
        }

        @Deprecated
        public Builder addWaypointTargets(Point ... waypointTargets) {
            return this.waypointTargets(Arrays.asList(waypointTargets));
        }

        public Builder waypointTargets(@NonNull List<Point> waypointTargets) {
            this.waypointTargets = waypointTargets;
            return this;
        }

        abstract Builder waypointTargets(@Nullable String var1);

        public Builder addWaypointTarget(@Nullable Point waypointTarget) {
            this.waypointTargets.add(waypointTarget);
            return this;
        }

        public abstract Builder enableRefresh(Boolean var1);

        public Builder post() {
            this.usePostMethod(true);
            return this;
        }

        public Builder get() {
            this.usePostMethod(false);
            return this;
        }

        public abstract Builder walkingOptions(@NonNull WalkingOptions var1);

        abstract WalkingOptions walkingOptions();

        abstract Builder usePostMethod(@NonNull Boolean var1);

        abstract Boolean usePostMethod();

        abstract MapboxDirections autoBuild();

        public MapboxDirections build() {
            if (this.origin != null) {
                this.coordinates.add(0, this.origin);
            }
            if (this.destination != null) {
                this.coordinates.add(this.destination);
            }
            if (this.coordinates.size() < 2) {
                throw new ServicesException("An origin and destination are required before making the directions API request.");
            }
            if (!this.waypointIndices.isEmpty()) {
                if (this.waypointIndices.size() < 2) {
                    throw new ServicesException("Waypoints must be a list of at least two indexes separated by ';'");
                }
                if (this.waypointIndices.get(0) != 0 || this.waypointIndices.get(this.waypointIndices.size() - 1) != this.coordinates.size() - 1) {
                    throw new ServicesException("Waypoints must contain indices of the first and last coordinates");
                }
                for (int i = 1; i < this.waypointIndices.size() - 1; ++i) {
                    if (this.waypointIndices.get(i) >= 0 && this.waypointIndices.get(i) < this.coordinates.size()) continue;
                    throw new ServicesException("Waypoints index too large (no corresponding coordinate)");
                }
            }
            if (!this.waypointNames.isEmpty()) {
                String waypointNamesStr = FormatUtils.formatWaypointNames(this.waypointNames);
                this.waypointNames(waypointNamesStr);
            }
            if (!this.waypointTargets.isEmpty()) {
                if (this.waypointTargets.size() != this.coordinates.size()) {
                    throw new ServicesException("Number of waypoint targets must match  the number of waypoints provided.");
                }
                this.waypointTargets(FormatUtils.formatPointsList(this.waypointTargets));
            }
            if (!this.approaches.isEmpty()) {
                if (this.approaches.size() != this.coordinates.size()) {
                    throw new ServicesException("Number of approach elements must match number of coordinates provided.");
                }
                String formattedApproaches = FormatUtils.formatApproaches(this.approaches);
                if (formattedApproaches == null) {
                    throw new ServicesException("All approaches values must be one of curb, unrestricted");
                }
                this.approaches(formattedApproaches);
            }
            this.coordinates(this.coordinates);
            this.bearing(FormatUtils.formatBearings(this.bearings));
            this.annotation(FormatUtils.join((CharSequence)",", this.annotations));
            this.radius(FormatUtils.formatRadiuses(this.radiuses));
            this.waypointIndices(FormatUtils.join((CharSequence)";", this.waypointIndices, (boolean)true));
            MapboxDirections directions = this.autoBuild();
            if (!MapboxUtils.isAccessTokenValid((String)directions.accessToken())) {
                throw new ServicesException("Using Mapbox Services requires setting a valid access token.");
            }
            return directions;
        }
    }
}

