/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps.widgets;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.ViewPropertyAnimatorCompat;
import android.support.v4.view.ViewPropertyAnimatorListener;
import android.support.v4.view.ViewPropertyAnimatorListenerAdapter;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.mapbox.mapboxsdk.maps.MapboxMap;

public final class CompassView
extends ImageView
implements Runnable {
    public static final long TIME_WAIT_IDLE = 500L;
    public static final long TIME_MAP_NORTH_ANIMATION = 150L;
    private static final long TIME_FADE_ANIMATION = 500L;
    private float rotation = 0.0f;
    private boolean fadeCompassViewFacingNorth = true;
    @Nullable
    private ViewPropertyAnimatorCompat fadeAnimator;
    private MapboxMap.OnCompassAnimationListener compassAnimationListener;
    private boolean isAnimating = false;
    @DrawableRes
    private int compassImageResource;
    private boolean legacyImageDrawableSetter = false;

    public CompassView(@NonNull Context context) {
        super(context);
        this.initialize(context);
    }

    public CompassView(@NonNull Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initialize(context);
    }

    public CompassView(@NonNull Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initialize(context);
    }

    private void initialize(Context context) {
        this.setEnabled(false);
        float screenDensity = context.getResources().getDisplayMetrics().density;
        ViewGroup.LayoutParams lp = new ViewGroup.LayoutParams((int)(48.0f * screenDensity), (int)(48.0f * screenDensity));
        this.setLayoutParams(lp);
    }

    public void injectCompassAnimationListener(@NonNull MapboxMap.OnCompassAnimationListener compassAnimationListener) {
        this.compassAnimationListener = compassAnimationListener;
    }

    public void isAnimating(boolean isAnimating) {
        this.isAnimating = isAnimating;
    }

    public void resetAnimation() {
        if (this.fadeAnimator != null) {
            this.fadeAnimator.cancel();
        }
        this.fadeAnimator = null;
    }

    public boolean isHidden() {
        return this.fadeCompassViewFacingNorth && this.isFacingNorth();
    }

    public boolean isFacingNorth() {
        return (double)Math.abs(this.rotation) >= 359.0 || (double)Math.abs(this.rotation) <= 1.0;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (enabled && !this.isHidden()) {
            this.resetAnimation();
            this.setAlpha(1.0f);
            this.setVisibility(0);
            this.update(this.rotation);
        } else {
            this.resetAnimation();
            this.setAlpha(0.0f);
            this.setVisibility(4);
        }
    }

    public void update(double bearing) {
        this.rotation = (float)bearing;
        if (!this.isEnabled()) {
            return;
        }
        if (this.isHidden()) {
            if (this.getVisibility() == 4 || this.fadeAnimator != null) {
                return;
            }
            this.postDelayed(this, 500L);
            return;
        }
        this.resetAnimation();
        this.setAlpha(1.0f);
        this.setVisibility(0);
        this.notifyCompassAnimationListenerWhenAnimating();
        this.setRotation(this.rotation);
    }

    public void fadeCompassViewFacingNorth(boolean compassFadeFacingNorth) {
        this.fadeCompassViewFacingNorth = compassFadeFacingNorth;
    }

    public boolean isFadeCompassViewFacingNorth() {
        return this.fadeCompassViewFacingNorth;
    }

    public void setCompassImage(Drawable compass) {
        this.legacyImageDrawableSetter = true;
        this.setImageDrawable(compass);
    }

    public Drawable getCompassImage() {
        return this.getDrawable();
    }

    @Override
    public void run() {
        if (this.isHidden()) {
            this.compassAnimationListener.onCompassAnimationFinished();
            this.resetAnimation();
            this.setLayerType(2, null);
            this.fadeAnimator = ViewCompat.animate((View)this).alpha(0.0f).setDuration(500L);
            this.fadeAnimator.setListener((ViewPropertyAnimatorListener)new ViewPropertyAnimatorListenerAdapter(){

                public void onAnimationEnd(View view) {
                    CompassView.this.setLayerType(0, null);
                    CompassView.this.setVisibility(4);
                    CompassView.this.resetAnimation();
                }
            });
        }
    }

    private void notifyCompassAnimationListenerWhenAnimating() {
        if (this.isAnimating) {
            this.compassAnimationListener.onCompassAnimation();
        }
    }

    public int getCompassImageResource() {
        return this.compassImageResource;
    }

    public void setCompassImageResource(int drawableRes) {
        this.compassImageResource = drawableRes;
        this.setImageResource(this.compassImageResource);
    }

    public boolean isLegacyImageDrawableSetter() {
        return this.legacyImageDrawableSetter;
    }
}

