/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.style.layers;

import android.support.annotation.ColorInt;
import android.support.annotation.UiThread;
import com.mapbox.mapboxsdk.style.layers.Filter;
import com.mapbox.mapboxsdk.style.layers.Layer;
import com.mapbox.mapboxsdk.style.layers.PropertyValue;
import com.mapbox.mapboxsdk.utils.ColorUtils;

@UiThread
public class CircleLayer
extends Layer {
    public CircleLayer(long nativePtr) {
        super(nativePtr);
    }

    public CircleLayer(String layerId, String sourceId) {
        this.initialize(layerId, sourceId);
    }

    protected native void initialize(String var1, String var2);

    public void setSourceLayer(String sourceLayer) {
        this.nativeSetSourceLayer(sourceLayer);
    }

    public CircleLayer withSourceLayer(String sourceLayer) {
        this.setSourceLayer(sourceLayer);
        return this;
    }

    public void setFilter(Filter.Statement filter) {
        this.nativeSetFilter(filter.toArray());
    }

    public CircleLayer withFilter(Filter.Statement filter) {
        this.setFilter(filter);
        return this;
    }

    public CircleLayer withProperties(PropertyValue<?> ... properties) {
        this.setProperties(properties);
        return this;
    }

    public PropertyValue<Float> getCircleRadius() {
        return new PropertyValue<Object>("circle-radius", this.nativeGetCircleRadius());
    }

    public PropertyValue<String> getCircleColor() {
        return new PropertyValue<Object>("circle-color", this.nativeGetCircleColor());
    }

    @ColorInt
    public int getCircleColorAsInt() {
        PropertyValue<String> value = this.getCircleColor();
        if (value.isValue()) {
            return ColorUtils.rgbaToColor(value.getValue());
        }
        throw new RuntimeException("circle-color was set as a Function");
    }

    public PropertyValue<Float> getCircleBlur() {
        return new PropertyValue<Object>("circle-blur", this.nativeGetCircleBlur());
    }

    public PropertyValue<Float> getCircleOpacity() {
        return new PropertyValue<Object>("circle-opacity", this.nativeGetCircleOpacity());
    }

    public PropertyValue<Float[]> getCircleTranslate() {
        return new PropertyValue<Object>("circle-translate", this.nativeGetCircleTranslate());
    }

    public PropertyValue<String> getCircleTranslateAnchor() {
        return new PropertyValue<Object>("circle-translate-anchor", this.nativeGetCircleTranslateAnchor());
    }

    public PropertyValue<String> getCirclePitchScale() {
        return new PropertyValue<Object>("circle-pitch-scale", this.nativeGetCirclePitchScale());
    }

    public PropertyValue<Float> getCircleStrokeWidth() {
        return new PropertyValue<Object>("circle-stroke-width", this.nativeGetCircleStrokeWidth());
    }

    public PropertyValue<String> getCircleStrokeColor() {
        return new PropertyValue<Object>("circle-stroke-color", this.nativeGetCircleStrokeColor());
    }

    @ColorInt
    public int getCircleStrokeColorAsInt() {
        PropertyValue<String> value = this.getCircleStrokeColor();
        if (value.isValue()) {
            return ColorUtils.rgbaToColor(value.getValue());
        }
        throw new RuntimeException("circle-stroke-color was set as a Function");
    }

    public PropertyValue<Float> getCircleStrokeOpacity() {
        return new PropertyValue<Object>("circle-stroke-opacity", this.nativeGetCircleStrokeOpacity());
    }

    private native Object nativeGetCircleRadius();

    private native Object nativeGetCircleColor();

    private native Object nativeGetCircleBlur();

    private native Object nativeGetCircleOpacity();

    private native Object nativeGetCircleTranslate();

    private native Object nativeGetCircleTranslateAnchor();

    private native Object nativeGetCirclePitchScale();

    private native Object nativeGetCircleStrokeWidth();

    private native Object nativeGetCircleStrokeColor();

    private native Object nativeGetCircleStrokeOpacity();

    @Override
    protected native void finalize() throws Throwable;
}

