package com.mapbox.mapboxsdk.plugins.china.shift;

import android.location.Location;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * The class shifts the device's real-time location coordinates so that the returned Location object has
 * GCJ-02 coordinates.
 */
public class ShiftLocation {

  private static ShiftForChina shiftForChina = new ShiftForChina();

  /**
   * This method shifts the device's current location  coordinates into the GCJ-O2 equivalent.
   *
   * @param unshiftedLocationObject the Location object that is provided by the device. This object has
   *                                unshifted coordinates
   * @return a Location object with GCJ-02 equivalent coordinates.
   */
  public static Location shift(Location unshiftedLocationObject) {
    Location shiftedLocationObject = new Location(unshiftedLocationObject);
    String toJson = shiftForChina.shift(unshiftedLocationObject.getLongitude(),
      unshiftedLocationObject.getLatitude());
    try {
      JSONObject jsonObject = new JSONObject(toJson);
      shiftedLocationObject.setLongitude(jsonObject.getDouble("lon"));
      shiftedLocationObject.setLatitude(jsonObject.getDouble("lat"));
    } catch (JSONException jsonException) {
      jsonException.printStackTrace();
    }
    return shiftedLocationObject;
  }
}
