package com.mapbox.mapboxsdk.plugins.china.maps;

import com.mapbox.mapboxsdk.maps.MapboxMapOptions;
import com.mapbox.mapboxsdk.plugins.china.BuildConfig;
import com.mapbox.mapboxsdk.plugins.china.constants.MapboxChinaConstants;
import com.mapbox.mapboxsdk.plugins.china.constants.ChinaStyle;

/**
 * set map base url and style for China map.
 */
public class MapboxMapChinaOptions extends MapboxMapOptions {

  public MapboxMapChinaOptions() {
    super();
    // Skip setting the china values if using global flavor of plugin
    if (BuildConfig.FLAVOR.contains(MapboxChinaConstants.FLAVOR_GLOBAL)) {
      return;
    }
    apiBaseUrl(MapboxChinaConstants.BASE_API_URL);
    styleUrl(ChinaStyle.MAPBOX_STREETS_CHINESE);
  }
}
