package com.mapbox.mapboxsdk.plugins.china.services;

import com.mapbox.mapboxsdk.plugins.china.ChinaConstants;
import com.mapbox.services.api.geocoding.v5.MapboxGeocoding;

/**
 * The Mapbox geocoding client (v5).
 * <p>
 * This class defaults to the China endpoint for all queries.
 * Set the Base Url into .cn.
 */
public class MapboxGeocodingChina extends MapboxGeocoding {
  public MapboxGeocodingChina(MapboxGeocoding.Builder builder) {
    super(builder);
    builder.setBaseUrl(ChinaConstants.BASE_API_URL);
    builder.setLanguages(ChinaConstants.LANGUAGE_SIMPLIFIED_CHINESE);
  }
}
