package com.mapbox.mapboxsdk.plugins.china.services;

import com.mapbox.mapboxsdk.plugins.china.ChinaConstants;
import com.mapbox.services.api.mapmatching.v5.MapboxMapMatching;

/**
 * The Mapbox map matching interface (v5)
 * <p>
 * The Mapbox Map Matching API snaps fuzzy, inaccurate traces from a GPS unit or a phone to the
 * OpenStreetMap road and path network using the Directions API. This produces clean paths that can
 * be displayed on a map or used for other analysis.
 * <p>
 * This class defaults to the China endpoint for all queries.
 * Set the Base Url into .cn.
 * @see <a href="https://www.mapbox.com/api-documentation/#map-matching">Map matching API documentation</a>
 * @since 2.0.0
 */
public class MapboxMapMatchingChina extends MapboxMapMatching {
  public MapboxMapMatchingChina(MapboxMapMatching.Builder builder) {
    super(builder);
    builder.setBaseUrl(ChinaConstants.BASE_API_URL);
  }
}
