package com.mapbox.mapboxsdk.plugins.china.services;

import com.mapbox.mapboxsdk.plugins.china.ChinaConstants;
import com.mapbox.services.api.directionsmatrix.v1.MapboxDirectionsMatrix;

/**
 * The Directions Matrix API returns all travel times between many points. The Matrix API will always return the
 * duration on the fastest route. Durations between points may not be symmetric (for example A to B may have a
 * different duration than B to A), as the routes may differ by direction due to one-way streets or turn restrictions.
 * The Matrix API returns durations in seconds. It does not return route geometries or distances.
 * <p>
 * This API allows you to build tools that efficiently check the reachability of coordinates from each other, filter
 * points by travel time, or run your own algorithms for solving optimization problems.
 * <p>
 * The standard limit for request are a maximum 60 requests per minute and maximum 25 input coordinates. For example
 * you can request a symmetric 25x25 matrix, an asymmetric 1x24 matrix with distinct coordinates or a 12x24 where
 * sources and destinations share some coordinates. For higher volumes contact us.
 * <p>
 * This replace the distance.v1 API
 * This class defaults to the China endpoint for all queries.
 * Set the Base Url into .cn.
 * @see <a href="https://www.mapbox.com/api-documentation/#directions-matrix">API documentation</a>
 * @since 2.1.0
 */
public class MapboxDirectionsMatrixChina extends MapboxDirectionsMatrix {
  public MapboxDirectionsMatrixChina(MapboxDirectionsMatrix.Builder builder) {
    super(builder);
    builder.setBaseUrl(ChinaConstants.BASE_API_URL);
  }
}
