package com.mapbox.mapboxsdk.plugins.china.services;

import com.mapbox.mapboxsdk.plugins.china.ChinaConstants;
import com.mapbox.services.api.directions.v5.MapboxDirections;

/**
 * The Directions API allows the calculation of routes between coordinates. The fastest route
 * is returned with geometries, and turn-by-turn instructions. The Mapbox Directions API supports
 * routing for driving cars, riding bicycles and walking.
 * <p>
 * This class defaults to the China endpoint for all queries.
 * Set the Base Url into .cn.
 */
public class MapboxDirectionsChina extends MapboxDirections {
  public MapboxDirectionsChina(MapboxDirections.Builder builder) {
    super(builder);
    builder.setBaseUrl(ChinaConstants.BASE_API_URL);
  }
}
