/*
 * Decompiled with CFR 0.152.
 */
package com.m14n.android.ex;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Path;
import android.graphics.RectF;
import android.util.AttributeSet;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatImageView;
import com.m14n.R;

public class RoundedImageView
extends AppCompatImageView {
    private float mRadius;
    private float mClipSize;
    private final Path mClipPath = new Path();
    private final RectF mClipRect = new RectF();

    public RoundedImageView(Context context) {
        super(context);
    }

    public RoundedImageView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.initAttrs(context, attrs);
    }

    public RoundedImageView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initAttrs(context, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initAttrs(Context context, AttributeSet attrs) {
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.RoundedImageView, 0, 0);
        try {
            this.mRadius = a.getDimension(R.styleable.RoundedImageView_cornerRadius, 0.0f);
            this.mClipSize = a.getDimension(R.styleable.RoundedImageView_clipSize, 0.0f);
        }
        finally {
            a.recycle();
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.mClipRect.left = this.mClipSize;
        this.mClipRect.top = this.mClipSize;
        this.mClipRect.bottom = (float)this.getMeasuredHeight() - this.mClipSize;
        this.mClipRect.right = (float)this.getMeasuredWidth() - this.mClipSize;
        this.mClipPath.reset();
        this.mClipPath.addRoundRect(this.mClipRect, this.mRadius, this.mRadius, Path.Direction.CW);
    }

    protected void onDraw(Canvas canvas) {
        canvas.clipPath(this.mClipPath);
        super.onDraw(canvas);
    }
}

