/*
 * Decompiled with CFR 0.152.
 */
package com.m14n.android.ex;

import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import androidx.fragment.app.DialogFragment;
import androidx.fragment.app.FragmentActivity;
import com.m14n.android.ex.OnCloseDialogListener;

public class AlertDialogFragment
extends DialogFragment {
    private static final String POSITIVE_KEY = "positive";
    private static final String NEUTRAL_KEY = "neutral";
    private static final String NEGATIVE_KEY = "negative";

    public static DialogFragment create(int titleId, int messageId, int positiveId, int neutralId, int negativeId) {
        if (positiveId == 0) {
            throw new IllegalArgumentException("The dialog must have positive button!");
        }
        AlertDialogFragment fragment = new AlertDialogFragment();
        Bundle args = new Bundle();
        args.putInt("title", titleId);
        args.putInt("message", messageId);
        args.putInt(POSITIVE_KEY, positiveId);
        args.putInt(NEUTRAL_KEY, neutralId);
        args.putInt(NEGATIVE_KEY, negativeId);
        fragment.setArguments(args);
        return fragment;
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        int negativeId;
        int messageId;
        FragmentActivity activity = this.getActivity();
        Bundle args = this.getArguments();
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)activity);
        int titleId = args.getInt("title");
        if (titleId != 0) {
            builder.setTitle(titleId);
        }
        if ((messageId = args.getInt("message")) != 0) {
            builder.setMessage(messageId);
        }
        OnCloseDialogListener closeListener = activity instanceof OnCloseDialogListener ? (OnCloseDialogListener)activity : null;
        builder.setPositiveButton(args.getInt(POSITIVE_KEY), (DialogInterface.OnClickListener)new ClickListener(OnCloseDialogListener.Result.POSITIVE, closeListener));
        int neutralId = args.getInt(NEUTRAL_KEY);
        if (neutralId > 0) {
            builder.setNeutralButton(neutralId, (DialogInterface.OnClickListener)new ClickListener(OnCloseDialogListener.Result.NEUTRAL, closeListener));
        }
        if ((negativeId = args.getInt(NEGATIVE_KEY)) > 0) {
            builder.setNegativeButton(negativeId, (DialogInterface.OnClickListener)new ClickListener(OnCloseDialogListener.Result.NEGATIVE, closeListener));
        }
        return builder.setCancelable(false).create();
    }

    private class ClickListener
    implements DialogInterface.OnClickListener {
        private final OnCloseDialogListener.Result result;
        private final OnCloseDialogListener closeListener;

        public ClickListener(OnCloseDialogListener.Result result, OnCloseDialogListener closeListener) {
            this.result = result;
            this.closeListener = closeListener;
        }

        public void onClick(DialogInterface dialog, int which) {
            dialog.cancel();
            if (this.closeListener != null) {
                this.closeListener.onClose(AlertDialogFragment.this.getTag(), this.result);
            }
        }
    }
}

