package com.m14n.android.ex.debug;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;

public class DebugFragment extends Fragment {

    private static final String TAG = DebugFragment.class.getSimpleName();

    private String mName;

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        mName = getTag();
        if (TextUtils.isEmpty(mName)) {
            mName = getClass().getSimpleName();
        }
        Log.d(TAG, "onCreate: " + mName);
    }

    @Nullable
    @Override
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container,
            @Nullable Bundle savedInstanceState) {
        Log.d(TAG, "onCreateView: " + mName);
        return super.onCreateView(inflater, container, savedInstanceState);
    }

    @Override
    public void onDestroyView() {
        Log.d(TAG, "onDestroyView: " + mName);
        super.onDestroyView();
    }

    @Override
    public void onAttach(Context context) {
        Log.d(TAG, "onAttach: " + mName);
        super.onAttach(context);
    }

    @Override
    public void onDetach() {
        Log.d(TAG, "onDetach: " + mName);
        super.onDetach();
    }

    @Override
    public void onStart() {
        Log.d(TAG, "onStart: " + mName);
        super.onStart();
    }

    @Override
    public void onStop() {
        Log.d(TAG, "onStop: " + mName);
        super.onStop();
    }

    @Override
    public void onResume() {
        Log.d(TAG, "onResume: " + mName);
        super.onResume();
    }

    @Override
    public void onPause() {
        Log.d(TAG, "onPause: " + mName);
        super.onPause();
    }

    @Override
    public void onDestroy() {
        Log.d(TAG, "onDestroy: " + mName);
        super.onDestroy();
    }
}
