package com.m14n.android.ex;


import android.app.DatePickerDialog;
import android.app.Dialog;
import android.os.Bundle;
import android.support.v4.app.DialogFragment;

import com.m14n.ex.Ex;

import java.util.Calendar;

public class DatePickerFragment extends DialogFragment {

    private static final String KEY_YEAR = "keyYear";
    private static final String KEY_MONTH = "keyMonth";
    private static final String KEY_DAY = "keyDay";
    private static final String KEY_MIN_DATE = "keyMinDate";
    private static final String KEY_MAX_DATE = "keyMaxDate";
    private static final String KEY_TITLE = "keyTitle";

    private DatePickerDialog.OnDateSetListener mDateListener;

    public static DatePickerFragment create(String title, int year, int month, int day, Long minDate, Long maxDate) {
        DatePickerFragment fragment = new DatePickerFragment();
        final Bundle args = new Bundle();
        args.putString(KEY_TITLE, title);
        args.putInt(KEY_YEAR, year);
        args.putInt(KEY_MONTH, month);
        args.putInt(KEY_DAY, day);
        args.putLong(KEY_MIN_DATE, minDate != null ? minDate : Long.MIN_VALUE);
        args.putLong(KEY_MAX_DATE, maxDate != null ? maxDate : Long.MAX_VALUE);
        fragment.setArguments(args);
        return fragment;
    }

    public void setDateListener(DatePickerDialog.OnDateSetListener dateListener) {
        mDateListener = dateListener;
    }

    @Override
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        final Bundle theArguments = getArguments();
        int year = theArguments.getInt(KEY_YEAR);
        int month = theArguments.getInt(KEY_MONTH);
        int day = theArguments.getInt(KEY_DAY);
        final DatePickerDialog theDatePickerDialog = new DatePickerDialog(getContext(), getTheme(), mDateListener,
                year, month, day);
        long minDate = theArguments.getLong(KEY_MIN_DATE);
        if (minDate != Long.MIN_VALUE) {
            theDatePickerDialog.getDatePicker().setMinDate(minDate);
        }
        long maxDate = theArguments.getLong(KEY_MAX_DATE);
        if (maxDate != Long.MAX_VALUE) {
            theDatePickerDialog.getDatePicker().setMaxDate(maxDate);
        }
        final String theTitle = theArguments.getString(KEY_TITLE);
        if (Ex.isNotEmpty(theTitle)) {
            theDatePickerDialog.setTitle(theTitle);
        }

        return theDatePickerDialog;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String mTitle;
        private long mDate;
        private long mMinDate;
        private long mMaxDate;

        private Builder() {
        }

        public Builder setTitle(String title) {
            mTitle = title;
            return this;
        }

        public Builder setDate(long date) {
            mDate = date;
            return this;
        }

        public Builder setMinDate(long minDate) {
            mMinDate = minDate;
            return this;
        }

        public Builder setMaxDate(long maxDate) {
            mMaxDate = maxDate;
            return this;
        }

        public DatePickerFragment build() {
            Calendar theCalendar = Calendar.getInstance();
            theCalendar.setTimeInMillis(mDate);
            return DatePickerFragment.create(mTitle, theCalendar.get(Calendar.YEAR),
                    theCalendar.get(Calendar.MONTH),
                    theCalendar.get(Calendar.DATE), mMinDate, mMaxDate);
        }

    }
}