/*
 * Decompiled with CFR 0.152.
 */
package com.lionscribe.open.notificationchannelcompat.ui.widgets;

import android.content.Context;
import android.support.v7.preference.Preference;
import android.support.v7.preference.PreferenceViewHolder;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.lionscribe.open.notificationchannelcompat.R;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class TwoTargetPreference
extends Preference {
    public static final int ICON_SIZE_DEFAULT = 0;
    public static final int ICON_SIZE_MEDIUM = 1;
    public static final int ICON_SIZE_SMALL = 2;
    private int mIconSize;
    private int mSmallIconSize;
    private int mMediumIconSize;

    public TwoTargetPreference(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context);
    }

    public TwoTargetPreference(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    public TwoTargetPreference(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public TwoTargetPreference(Context context) {
        super(context);
        this.init(context);
    }

    private void init(Context context) {
        this.setLayoutResource(R.layout.preference_two_target);
        this.mSmallIconSize = context.getResources().getDimensionPixelSize(R.dimen.two_target_pref_small_icon_size);
        this.mMediumIconSize = context.getResources().getDimensionPixelSize(R.dimen.two_target_pref_medium_icon_size);
        int secondTargetResId = this.getSecondTargetResId();
        if (secondTargetResId != 0) {
            this.setWidgetLayoutResource(secondTargetResId);
        }
    }

    public void setIconSize(int iconSize) {
        this.mIconSize = iconSize;
    }

    public void onBindViewHolder(PreferenceViewHolder holder) {
        super.onBindViewHolder(holder);
        ImageView icon = (ImageView)holder.itemView.findViewById(16908294);
        switch (this.mIconSize) {
            case 2: {
                icon.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(this.mSmallIconSize, this.mSmallIconSize));
                break;
            }
            case 1: {
                icon.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(this.mMediumIconSize, this.mMediumIconSize));
            }
        }
        View divider = holder.findViewById(R.id.two_target_divider);
        View widgetFrame = holder.findViewById(16908312);
        boolean shouldHideSecondTarget = this.shouldHideSecondTarget();
        if (divider != null) {
            divider.setVisibility(shouldHideSecondTarget ? 8 : 0);
        }
        if (widgetFrame != null) {
            widgetFrame.setVisibility(shouldHideSecondTarget ? 8 : 0);
        }
    }

    protected boolean shouldHideSecondTarget() {
        return this.getSecondTargetResId() == 0;
    }

    protected int getSecondTargetResId() {
        return 0;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface IconSize {
    }
}

