/*
 * Decompiled with CFR 0.152.
 */
package com.lionscribe.open.notificationchannelcompat.ui.widgets;

import android.content.Context;
import android.support.v7.preference.PreferenceViewHolder;
import android.util.AttributeSet;
import android.view.View;
import android.widget.CheckBox;
import com.lionscribe.open.notificationchannelcompat.R;
import com.lionscribe.open.notificationchannelcompat.ui.widgets.TwoTargetPreference;

public class MasterCheckBoxPreference
extends TwoTargetPreference {
    private CheckBox mCheckBox;
    private boolean mChecked;
    private boolean mEnableCheckBox = true;

    public MasterCheckBoxPreference(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    public MasterCheckBoxPreference(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public MasterCheckBoxPreference(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public MasterCheckBoxPreference(Context context) {
        super(context);
    }

    @Override
    protected int getSecondTargetResId() {
        return R.layout.preference_widget_master_checkbox;
    }

    @Override
    public void onBindViewHolder(PreferenceViewHolder holder) {
        super.onBindViewHolder(holder);
        View widgetView = holder.findViewById(16908312);
        if (widgetView != null) {
            widgetView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (MasterCheckBoxPreference.this.mCheckBox != null && !MasterCheckBoxPreference.this.mCheckBox.isEnabled()) {
                        return;
                    }
                    MasterCheckBoxPreference.this.setChecked(!MasterCheckBoxPreference.this.mChecked);
                    if (!MasterCheckBoxPreference.this.callChangeListener(MasterCheckBoxPreference.this.mChecked)) {
                        MasterCheckBoxPreference.this.setChecked(!MasterCheckBoxPreference.this.mChecked);
                    } else {
                        MasterCheckBoxPreference.this.persistBoolean(MasterCheckBoxPreference.this.mChecked);
                    }
                }
            });
        }
        this.mCheckBox = (CheckBox)holder.findViewById(R.id.checkboxWidget);
        if (this.mCheckBox != null) {
            this.mCheckBox.setContentDescription(this.getTitle());
            this.mCheckBox.setChecked(this.mChecked);
            this.mCheckBox.setEnabled(this.mEnableCheckBox);
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.setCheckBoxEnabled(enabled);
    }

    protected void onSetInitialValue(Object defaultValue) {
        this.setChecked(this.getPersistedBoolean(defaultValue == null ? false : (Boolean)defaultValue));
    }

    public boolean isChecked() {
        return this.mCheckBox != null && this.mChecked;
    }

    public void setChecked(boolean checked) {
        this.mChecked = checked;
        if (this.mCheckBox != null) {
            this.mCheckBox.setChecked(checked);
        }
    }

    public void setCheckBoxEnabled(boolean enabled) {
        this.mEnableCheckBox = enabled;
        if (this.mCheckBox != null) {
            this.mCheckBox.setEnabled(enabled);
        }
    }

    public CheckBox getCheckBox() {
        return this.mCheckBox;
    }
}

