/*
 * Decompiled with CFR 0.152.
 */
package com.lionscribe.open.notificationchannelcompat;

import android.content.Context;
import android.content.Intent;
import android.content.res.TypedArray;
import android.net.Uri;
import android.os.Build;
import android.support.v7.preference.Preference;
import android.text.TextUtils;
import android.util.AttributeSet;
import com.lionscribe.open.notificationchannelcompat.R;
import com.lionscribe.open.notificationchannelcompat.ui.PreferencesChannelsActivity;

public class NotificationChannelPreference
extends Preference {
    String _channelId;

    public NotificationChannelPreference(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs);
    }

    public NotificationChannelPreference(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    public NotificationChannelPreference(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public NotificationChannelPreference(Context context) {
        super(context);
    }

    public static void launchSettings(Context context) {
        NotificationChannelPreference.launchSettings(context, null);
    }

    public static void launchSettings(Context context, String channelId) {
        if (Build.VERSION.SDK_INT >= 26) {
            NotificationChannelPreference.launchSystemNotificationsSettings(context, channelId);
        } else {
            Intent i = new Intent(context, PreferencesChannelsActivity.class);
            if (!TextUtils.isEmpty((CharSequence)channelId)) {
                i.putExtra("INTENT_EXTRA_CHANNEL_ID", channelId);
            }
            context.startActivity(i);
        }
    }

    public static boolean launchSystemNotificationsSettings(Context context, String channelId) {
        Intent intent = new Intent();
        if (Build.VERSION.SDK_INT >= 26) {
            if (channelId == null) {
                intent.setAction("android.settings.APP_NOTIFICATION_SETTINGS");
            } else {
                intent.setAction("android.settings.CHANNEL_NOTIFICATION_SETTINGS");
                intent.putExtra("android.provider.extra.CHANNEL_ID", channelId);
            }
            intent.putExtra("android.provider.extra.APP_PACKAGE", context.getPackageName());
        } else if (Build.VERSION.SDK_INT >= 21) {
            intent.setAction("android.settings.APP_NOTIFICATION_SETTINGS");
            intent.putExtra("app_package", context.getPackageName());
            intent.putExtra("app_uid", context.getApplicationInfo().uid);
        } else {
            intent.setAction("android.settings.APPLICATION_DETAILS_SETTINGS");
            intent.addCategory("android.intent.category.DEFAULT");
            intent.setData(Uri.parse((String)("package:" + context.getPackageName())));
        }
        try {
            context.startActivity(intent);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    void init(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.NotificationChannelPreference);
        this._channelId = a.getString(R.styleable.NotificationChannelPreference_channelId);
        a.recycle();
    }

    protected void onClick() {
        super.onClick();
        NotificationChannelPreference.launchSettings(this.getContext(), this._channelId);
    }
}

