/*
 * Decompiled with CFR 0.152.
 */
package com.lionscribe.open.notificationchannelcompat;

import android.app.NotificationChannel;
import android.app.NotificationChannelGroup;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.RequiresApi;
import android.text.TextUtils;
import com.lionscribe.open.notificationchannelcompat.NotificationChannelCompat;
import java.util.ArrayList;
import java.util.List;

public final class NotificationChannelGroupCompat
implements Parcelable {
    public static final Parcelable.Creator<NotificationChannelGroupCompat> CREATOR = new Parcelable.Creator<NotificationChannelGroupCompat>(){

        public NotificationChannelGroupCompat createFromParcel(Parcel in) {
            return new NotificationChannelGroupCompat(in);
        }

        public NotificationChannelGroupCompat[] newArray(int size) {
            return new NotificationChannelGroupCompat[size];
        }
    };
    private static final int MAX_TEXT_LENGTH = 1000;
    private final String mId;
    private CharSequence mName;
    private String mDescription;
    private boolean mEnabled;
    private List<NotificationChannelCompat> mChannels = new ArrayList<NotificationChannelCompat>();
    private NotificationChannelGroup _notificationChannelGroup;

    public NotificationChannelGroupCompat(String id, CharSequence name) {
        if (Build.VERSION.SDK_INT >= 26) {
            this._notificationChannelGroup = new NotificationChannelGroup(id, name);
            this.mId = id;
            return;
        }
        this.mId = this.getTrimmedString(id);
        this.mName = name != null ? this.getTrimmedString(name.toString()) : null;
    }

    @RequiresApi(api=26)
    protected NotificationChannelGroupCompat(NotificationChannelGroup original) {
        this._notificationChannelGroup = original;
        this.mId = this._notificationChannelGroup.getId();
    }

    protected NotificationChannelGroupCompat(Parcel in) {
        if (Build.VERSION.SDK_INT >= 26) {
            this._notificationChannelGroup = (NotificationChannelGroup)in.readParcelable(NotificationChannelCompat.class.getClassLoader());
            this.mId = this.getId();
            return;
        }
        this.mId = in.readByte() != 0 ? in.readString() : null;
        this.mName = (CharSequence)TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
        this.mDescription = in.readByte() != 0 ? in.readString() : null;
        in.readTypedList(this.mChannels, NotificationChannelCompat.CREATOR);
        this.mEnabled = in.readByte() != 0;
    }

    private String getTrimmedString(String input) {
        if (input != null && input.length() > 1000) {
            return input.substring(0, 1000);
        }
        return input;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (Build.VERSION.SDK_INT >= 26) {
            this._notificationChannelGroup.writeToParcel(dest, flags);
            return;
        }
        if (this.mId != null) {
            dest.writeByte((byte)1);
            dest.writeString(this.mId);
        } else {
            dest.writeByte((byte)0);
        }
        TextUtils.writeToParcel((CharSequence)this.mName, (Parcel)dest, (int)flags);
        if (this.mDescription != null) {
            dest.writeByte((byte)1);
            dest.writeString(this.mDescription);
        } else {
            dest.writeByte((byte)0);
        }
        dest.writeTypedList(this.mChannels);
        dest.writeByte((byte)(this.mEnabled ? -1 : 0));
    }

    public String getId() {
        if (Build.VERSION.SDK_INT >= 26) {
            return this._notificationChannelGroup.getId();
        }
        return this.mId;
    }

    public CharSequence getName() {
        if (Build.VERSION.SDK_INT >= 26) {
            return this._notificationChannelGroup.getName();
        }
        return this.mName;
    }

    public String getDescription() {
        if (Build.VERSION.SDK_INT >= 28) {
            return this._notificationChannelGroup.getDescription();
        }
        if (Build.VERSION.SDK_INT >= 26) {
            return null;
        }
        return this.mDescription;
    }

    public void setDescription(String description) {
        if (Build.VERSION.SDK_INT >= 28) {
            this._notificationChannelGroup.setDescription(description);
            return;
        }
        if (Build.VERSION.SDK_INT >= 26) {
            return;
        }
        this.mDescription = this.getTrimmedString(description);
    }

    public List<NotificationChannelCompat> getChannels() {
        if (Build.VERSION.SDK_INT >= 26) {
            List originals = this._notificationChannelGroup.getChannels();
            ArrayList<NotificationChannelCompat> channels = new ArrayList<NotificationChannelCompat>(originals.size());
            for (NotificationChannel origin : originals) {
                channels.add(new NotificationChannelCompat(origin));
            }
            return channels;
        }
        return this.mChannels;
    }

    private void setChannels(List<NotificationChannelCompat> channels) {
        this.mChannels = channels;
    }

    @RequiresApi(api=26)
    public List<NotificationChannel> getChannelsOreo() {
        return this._notificationChannelGroup.getChannels();
    }

    public boolean isBlocked() {
        if (Build.VERSION.SDK_INT >= 28) {
            return this._notificationChannelGroup.isBlocked();
        }
        if (Build.VERSION.SDK_INT >= 26) {
            return false;
        }
        return !this.mEnabled;
    }

    public boolean isEnabled() {
        if (Build.VERSION.SDK_INT >= 26) {
            return !this._notificationChannelGroup.isBlocked();
        }
        return this.mEnabled;
    }

    protected void setEnabled(boolean enabled) {
        this.mEnabled = enabled;
    }

    public int describeContents() {
        if (Build.VERSION.SDK_INT >= 26) {
            return this._notificationChannelGroup.describeContents();
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NotificationChannelGroupCompat that = (NotificationChannelGroupCompat)o;
        if (Build.VERSION.SDK_INT >= 26) {
            return this._notificationChannelGroup.equals((Object)that._notificationChannelGroup);
        }
        if (this.isBlocked() != that.isBlocked()) {
            return false;
        }
        if (this.getId() != null ? !this.getId().equals(that.getId()) : that.getId() != null) {
            return false;
        }
        if (this.getName() != null ? !this.getName().equals(that.getName()) : that.getName() != null) {
            return false;
        }
        if (this.getDescription() != null ? !this.getDescription().equals(that.getDescription()) : that.getDescription() != null) {
            return false;
        }
        return this.getChannels() != null ? this.getChannels().equals(that.getChannels()) : that.getChannels() == null;
    }

    public int hashCode() {
        if (Build.VERSION.SDK_INT >= 26) {
            return this._notificationChannelGroup.hashCode();
        }
        int result = this.getId() != null ? this.getId().hashCode() : 0;
        result = 31 * result + (this.getName() != null ? this.getName().hashCode() : 0);
        result = 31 * result + (this.getDescription() != null ? this.getDescription().hashCode() : 0);
        result = 31 * result + (this.isBlocked() ? 1 : 0);
        result = 31 * result + (this.getChannels() != null ? this.getChannels().hashCode() : 0);
        return result;
    }

    public NotificationChannelGroupCompat clone() {
        NotificationChannelGroupCompat cloned = new NotificationChannelGroupCompat(this.getId(), this.getName());
        cloned.setDescription(this.getDescription());
        cloned.setEnabled(this.isEnabled());
        cloned.setChannels(this.getChannels());
        return cloned;
    }

    public String toString() {
        if (Build.VERSION.SDK_INT >= 26) {
            return this._notificationChannelGroup.toString();
        }
        return "NotificationChannelGroup{mId='" + this.mId + '\'' + ", mName=" + this.mName + ", mDescription=" + (!TextUtils.isEmpty((CharSequence)this.mDescription) ? "hasDescription " : "") + ", mBlocked=" + !this.mEnabled + ", mChannels=" + this.mChannels + '}';
    }

    @RequiresApi(api=26)
    NotificationChannelGroup getOreoVersion() {
        return this._notificationChannelGroup;
    }
}

