/*
 * Decompiled with CFR 0.152.
 */
package com.lionscribe.open.notificationchannelcompat.ui;

import android.app.NotificationManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.os.Bundle;
import android.os.Vibrator;
import android.provider.Settings;
import android.support.v14.preference.SwitchPreference;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v7.preference.ListPreference;
import android.support.v7.preference.Preference;
import android.support.v7.preference.PreferenceCategory;
import android.support.v7.preference.PreferenceFragmentCompat;
import android.support.v7.preference.PreferenceManager;
import android.support.v7.preference.PreferenceScreen;
import android.support.v7.view.ContextThemeWrapper;
import android.text.TextUtils;
import com.lionscribe.open.notificationchannelcompat.NotificationChannelCompat;
import com.lionscribe.open.notificationchannelcompat.NotificationChannelManagerHelper;
import com.lionscribe.open.notificationchannelcompat.R;
import com.lionscribe.open.notificationchannelcompat.ui.widgets.SoundTonePreference;

public class PreferencesChannelsSubFragment
extends PreferenceFragmentCompat {
    static final String FRAGMENT_TAG = "ChannelsSubFragment";
    NotificationChannelCompat _channel;
    SoundTonePreference _soundTonePreference;
    PreferenceCategory _preferenceDetailsCategory;

    public static PreferencesChannelsSubFragment newInstance(String channelId) {
        PreferencesChannelsSubFragment myFragment = new PreferencesChannelsSubFragment();
        Bundle args = new Bundle();
        args.putString("channelId", channelId);
        myFragment.setArguments(args);
        return myFragment;
    }

    public void onCreatePreferences(Bundle savedInstance, String rootPreferenceKey) {
        FragmentActivity activityContext = this.getActivity();
        String channelId = this.getArguments().getString("channelId", null);
        if (TextUtils.isEmpty((CharSequence)channelId)) {
            return;
        }
        NotificationChannelManagerHelper notificationManagerHelper = new NotificationChannelManagerHelper(this.getContext(), (NotificationManager)this.getContext().getSystemService("notification"));
        this._channel = notificationManagerHelper.getNotificationChannel(channelId);
        if (this._channel == null) {
            return;
        }
        PreferenceManager preferenceManager = this.getPreferenceManager();
        preferenceManager.setSharedPreferencesName("com.lionscribe.open.notificationchannelcompat_channel_prefs");
        PreferenceScreen preferenceScreen = preferenceManager.createPreferenceScreen((Context)activityContext);
        this.setPreferenceScreen(preferenceScreen);
        ContextThemeWrapper contextThemeWrapper = new ContextThemeWrapper((Context)activityContext, R.style.PreferenceThemeOverlay);
        PreferenceCategory preferenceCategory = new PreferenceCategory((Context)contextThemeWrapper);
        preferenceCategory.setTitle(this._channel.getName());
        SwitchPreference showNotificationsCategory = new SwitchPreference((Context)contextThemeWrapper);
        showNotificationsCategory.setTitle(R.string.app_notifications_switch_label);
        showNotificationsCategory.setKey(NotificationChannelManagerHelper.makeKey("channel_enabled_%s", channelId));
        showNotificationsCategory.setDefaultValue((Object)true);
        this._preferenceDetailsCategory = new PreferenceCategory((Context)contextThemeWrapper);
        ListPreference behaviourPreference = new ListPreference((Context)contextThemeWrapper);
        behaviourPreference.setKey(NotificationChannelManagerHelper.makeKey("channel_importance_%s", channelId));
        behaviourPreference.setTitle(R.string.notification_importance_title);
        behaviourPreference.setDialogTitle(R.string.notification_importance_title);
        behaviourPreference.setSummary((CharSequence)"%1$s");
        behaviourPreference.setEntries(R.array.notification_importance_entries_array);
        behaviourPreference.setEntryValues(R.array.notification_importance_values_array);
        behaviourPreference.setValueIndex(1);
        behaviourPreference.setOnPreferenceChangeListener(new Preference.OnPreferenceChangeListener(){

            public boolean onPreferenceChange(Preference preference, Object newValue) {
                ListPreference listPreference = (ListPreference)preference;
                listPreference.setValue(newValue.toString());
                preference.setSummary(listPreference.getEntry());
                return false;
            }
        });
        this._soundTonePreference = new SoundTonePreference((Context)contextThemeWrapper, (Fragment)this);
        this._soundTonePreference.setDefaultValue(Settings.System.DEFAULT_NOTIFICATION_URI.toString());
        this._soundTonePreference.setKey(NotificationChannelManagerHelper.makeKey("channel_sound_%s", channelId));
        this._soundTonePreference.setTitle(R.string.notification_channel_sound_title);
        String vs = "vibrator";
        Vibrator mVibrator = (Vibrator)this.getActivity().getSystemService(vs);
        boolean isVibrator = mVibrator.hasVibrator();
        SwitchPreference vibrateSwitch = null;
        if (isVibrator) {
            vibrateSwitch = new SwitchPreference((Context)contextThemeWrapper);
            vibrateSwitch.setTitle(R.string.notification_vibrate_title);
            vibrateSwitch.setKey(NotificationChannelManagerHelper.makeKey("channel_vibrationEnabled_%s", channelId));
            vibrateSwitch.setDefaultValue((Object)true);
        }
        SwitchPreference lightsSwitch = null;
        if (this.canPulseLight()) {
            lightsSwitch = new SwitchPreference((Context)contextThemeWrapper);
            lightsSwitch.setTitle(R.string.notification_show_lights_title);
            lightsSwitch.setKey(NotificationChannelManagerHelper.makeKey("channel_lights_%s", channelId));
            lightsSwitch.setDefaultValue((Object)true);
        }
        this.getPreferenceScreen().addPreference((Preference)preferenceCategory);
        preferenceCategory.addPreference((Preference)showNotificationsCategory);
        this.getPreferenceScreen().addPreference((Preference)this._preferenceDetailsCategory);
        this._preferenceDetailsCategory.addPreference((Preference)behaviourPreference);
        this._preferenceDetailsCategory.addPreference((Preference)this._soundTonePreference);
        if (vibrateSwitch != null) {
            this._preferenceDetailsCategory.addPreference((Preference)vibrateSwitch);
        }
        if (lightsSwitch != null) {
            this._preferenceDetailsCategory.addPreference((Preference)lightsSwitch);
        }
        this._preferenceDetailsCategory.setDependency(NotificationChannelManagerHelper.makeKey("channel_enabled_%s", channelId));
        PreferenceCategory infoCategory = new PreferenceCategory((Context)contextThemeWrapper);
        infoCategory.setEnabled(false);
        Preference info = new Preference((Context)contextThemeWrapper);
        info.setTitle((CharSequence)this._channel.getDescription());
        info.setIcon(R.drawable.ic_info_disabled);
        info.setEnabled(false);
        this.getPreferenceScreen().addPreference((Preference)infoCategory);
        infoCategory.addPreference(info);
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 1371) {
            this._soundTonePreference.handleActivityResult(data);
        } else {
            super.onActivityResult(requestCode, resultCode, data);
        }
    }

    boolean canPulseLight() {
        boolean bCanPulse = false;
        int id2 = Resources.getSystem().getIdentifier("config_intrusiveNotificationLed", "bool", "android");
        if (id2 > 0) {
            Resources res = Resources.getSystem();
            try {
                bCanPulse = res.getBoolean(id2);
            }
            catch (Resources.NotFoundException e) {
                // empty catch block
            }
        }
        if (bCanPulse) {
            try {
                String NOTIFICATION_LIGHT_PULSE = "notification_light_pulse";
                bCanPulse = Settings.System.getInt((ContentResolver)this.getContext().getContentResolver(), (String)"notification_light_pulse", (int)0) == 1;
            }
            catch (Exception e) {
                bCanPulse = false;
            }
        }
        return bCanPulse;
    }
}

