/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.gradle.python.wheel;

import com.linkedin.gradle.python.extension.PythonDetails;
import com.linkedin.gradle.python.wheel.PythonAbiContainer;
import com.linkedin.gradle.python.wheel.PythonWheelDetails;
import com.linkedin.gradle.python.wheel.WheelCache;
import com.linkedin.gradle.python.wheel.WheelCacheLayer;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;

public class LayeredWheelCache
implements WheelCache,
Serializable {
    private static final Logger logger = Logging.getLogger(LayeredWheelCache.class);
    private final Map<WheelCacheLayer, File> layeredCacheMap;
    private final PythonAbiContainer pythonAbiContainer;
    private boolean wheelsReady;

    public LayeredWheelCache(Map<WheelCacheLayer, File> layeredCacheMap, PythonAbiContainer pythonAbiContainer) {
        this.layeredCacheMap = layeredCacheMap;
        this.pythonAbiContainer = pythonAbiContainer;
        this.wheelsReady = true;
    }

    @Override
    public Optional<File> findWheel(String name, String version, PythonDetails pythonDetails) {
        for (WheelCacheLayer wheelCacheLayer : this.layeredCacheMap.keySet()) {
            Optional<File> wheel = this.findWheel(name, version, pythonDetails.getVirtualEnvInterpreter(), wheelCacheLayer);
            if (!wheel.isPresent()) continue;
            return wheel;
        }
        return Optional.empty();
    }

    @Override
    public Optional<File> findWheel(String name, String version, PythonDetails pythonDetails, WheelCacheLayer wheelCacheLayer) {
        return this.findWheel(name, version, pythonDetails.getVirtualEnvInterpreter(), wheelCacheLayer);
    }

    @Override
    public void storeWheel(File wheel) {
        for (WheelCacheLayer wheelCacheLayer : this.layeredCacheMap.keySet()) {
            this.storeWheel(wheel, wheelCacheLayer);
        }
    }

    @Override
    public void storeWheel(File wheel, WheelCacheLayer wheelCacheLayer) {
        File cacheDir = this.layeredCacheMap.get((Object)wheelCacheLayer);
        if (wheel != null && cacheDir != null) {
            try {
                Files.copy(wheel.toPath(), new File(cacheDir, wheel.getName()).toPath(), StandardCopyOption.COPY_ATTRIBUTES);
            }
            catch (FileAlreadyExistsException e) {
                logger.info("Wheel {} already stored in {}", (Object)wheel.getName(), (Object)cacheDir.toString());
            }
            catch (NoSuchFileException e) {
                logger.info("Could not store the wheel {} into {}.", (Object)wheel.getName(), (Object)cacheDir.toString());
                if (!wheel.exists()) {
                    logger.info("The wheel file does not exist");
                } else if (!cacheDir.exists()) {
                    logger.info("The cache directory does not exist.");
                    if (cacheDir.mkdirs()) {
                        logger.info("It was successfully recreated.");
                    }
                }
                if (wheelCacheLayer == WheelCacheLayer.PROJECT_LAYER) {
                    this.setWheelsReady(false);
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    @Override
    public Optional<File> getTargetDirectory() {
        return Optional.ofNullable(this.layeredCacheMap.get((Object)WheelCacheLayer.PROJECT_LAYER));
    }

    @Override
    public boolean isWheelsReady() {
        return this.wheelsReady;
    }

    @Override
    public void setWheelsReady(boolean wheelsReady) {
        this.wheelsReady = wheelsReady;
    }

    private Optional<File> findWheel(String name, String version, File pythonExecutable, WheelCacheLayer wheelCacheLayer) {
        File cacheDir = this.layeredCacheMap.get((Object)wheelCacheLayer);
        if (cacheDir == null) {
            return Optional.empty();
        }
        String wheelPrefix = name.replace("-", "_") + "-" + version.replace("-", "_") + "-";
        logger.info("Searching for {} {} with prefix {}", new Object[]{name, version, wheelPrefix});
        File[] files = cacheDir.listFiles((dir, entry) -> entry.startsWith(wheelPrefix) && entry.endsWith(".whl"));
        if (files == null) {
            return Optional.empty();
        }
        List wheelDetails = Arrays.stream(files).map(PythonWheelDetails::fromFile).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        logger.info("Wheels for version of package: {}", wheelDetails);
        Optional<PythonWheelDetails> foundWheel = wheelDetails.stream().filter(it -> this.wheelMatches(pythonExecutable, (PythonWheelDetails)it)).findFirst();
        logger.info("Found artifacts: {}", foundWheel);
        return foundWheel.map(it -> it.getFile());
    }

    private boolean wheelMatches(File pythonExecutable, PythonWheelDetails wheelDetails) {
        return this.pythonAbiContainer.matchesSupportedVersion(pythonExecutable, wheelDetails.getPythonTag(), wheelDetails.getAbiTag(), wheelDetails.getPlatformTag());
    }
}

