/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.gradle.python.wheel;

import com.linkedin.gradle.python.extension.PythonDetails;
import com.linkedin.gradle.python.wheel.PythonAbiContainer;
import com.linkedin.gradle.python.wheel.PythonWheelDetails;
import com.linkedin.gradle.python.wheel.WheelCache;
import com.linkedin.gradle.python.wheel.WheelCacheLayer;
import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;

public class FileBackedWheelCache
implements WheelCache,
Serializable {
    private static final Logger logger = Logging.getLogger(FileBackedWheelCache.class);
    private final File cacheDir;
    private final PythonAbiContainer pythonAbiContainer;

    public FileBackedWheelCache(File cacheDir, PythonAbiContainer pythonAbiContainer) {
        this.cacheDir = cacheDir;
        this.pythonAbiContainer = pythonAbiContainer;
    }

    @Override
    public Optional<File> findWheel(String name, String version, PythonDetails pythonDetails) {
        return this.findWheel(name, version, pythonDetails.getVirtualEnvInterpreter());
    }

    @Override
    public Optional<File> findWheel(String name, String version, PythonDetails pythonDetails, WheelCacheLayer wheelCacheLayer) {
        return Optional.empty();
    }

    @Override
    public void storeWheel(File wheel) {
    }

    @Override
    public void storeWheel(File wheel, WheelCacheLayer wheelCacheLayer) {
    }

    @Override
    public Optional<File> getTargetDirectory() {
        return Optional.empty();
    }

    @Override
    public boolean isWheelsReady() {
        return false;
    }

    @Override
    public void setWheelsReady(boolean wheelsReady) {
    }

    public Optional<File> findWheel(String name, String version, File pythonExecutable) {
        if (this.cacheDir == null) {
            return Optional.empty();
        }
        String wheelPrefix = name.replace("-", "_") + "-" + version.replace("-", "_") + "-";
        logger.info("Searching for {} {} with prefix {}", new Object[]{name, version, wheelPrefix});
        File[] files = this.cacheDir.listFiles((dir, entry) -> entry.startsWith(wheelPrefix) && entry.endsWith(".whl"));
        if (files == null) {
            return Optional.empty();
        }
        List wheelDetails = Arrays.stream(files).map(PythonWheelDetails::fromFile).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        logger.info("Wheels for version of package: {}", wheelDetails);
        Optional<PythonWheelDetails> foundWheel = wheelDetails.stream().filter(it -> this.wheelMatches(pythonExecutable, (PythonWheelDetails)it)).findFirst();
        logger.info("Found artifacts: {}", foundWheel);
        return foundWheel.map(it -> it.getFile());
    }

    public File getCacheDir() {
        return this.cacheDir;
    }

    private boolean wheelMatches(File pythonExecutable, PythonWheelDetails wheelDetails) {
        return this.pythonAbiContainer.matchesSupportedVersion(pythonExecutable, wheelDetails.getPythonTag(), wheelDetails.getAbiTag(), wheelDetails.getPlatformTag());
    }
}

