/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.gradle.python.util.pip;

import com.linkedin.gradle.python.PythonExtension;
import com.linkedin.gradle.python.extension.PythonDetails;
import com.linkedin.gradle.python.util.OperatingSystem;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Paths;
import java.util.Map;
import org.gradle.api.Project;

public class PipConfFile {
    private Project project;
    private PythonDetails pythonDetails;
    private String fileExtension;

    public PipConfFile(Project project, PythonDetails pythonDetails) {
        this.project = project;
        this.pythonDetails = pythonDetails;
        this.fileExtension = OperatingSystem.current().isWindows() ? "ini" : "conf";
    }

    public void buildPipConfFile() throws IOException {
        File pip = Paths.get(this.pythonDetails.getVirtualEnv().getAbsolutePath(), "pip." + this.fileExtension).toFile().getAbsoluteFile();
        if (!pip.exists()) {
            this.project.getLogger().info("creating pip." + this.fileExtension);
            pip.createNewFile();
            PythonExtension pythonExtension = (PythonExtension)this.project.getExtensions().getByType(PythonExtension.class);
            Map<String, Map<String, String>> pipConfig = pythonExtension.pipConfig;
            if (pipConfig.size() > 0) {
                PrintWriter writer = new PrintWriter(pip, "UTF-8");
                for (Map.Entry<String, Map<String, String>> entry : pipConfig.entrySet()) {
                    writer.println("[" + entry.getKey() + "]");
                    for (Map.Entry<String, String> entry2 : entry.getValue().entrySet()) {
                        writer.println(entry2.getKey() + " = " + entry2.getValue());
                    }
                }
                writer.close();
            }
        }
    }
}

