/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.gradle.python.util.internal.zipapp;

import com.linkedin.gradle.python.PythonExtension;
import com.linkedin.gradle.python.util.internal.zipapp.ZipappGenerator;
import com.linkedin.gradle.python.util.zipapp.EntryPointTemplateProvider;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;

public class ThinZipappGenerator
implements ZipappGenerator {
    protected static Logger logger = Logging.getLogger(ThinZipappGenerator.class);
    protected final Project project;
    protected final List<String> options;
    protected final EntryPointTemplateProvider templateProvider;
    protected final Map<String, String> extraProperties;

    public ThinZipappGenerator(Project project, List<String> options, EntryPointTemplateProvider templateProvider, Map<String, String> extraProperties) {
        this.project = project;
        this.options = options;
        this.templateProvider = templateProvider;
        this.extraProperties = extraProperties == null ? new HashMap() : extraProperties;
    }

    @Override
    public Map<String, String> buildSubstitutions(PythonExtension extension, String entry) {
        HashMap<String, String> substitutions = new HashMap<String, String>();
        substitutions.putAll(this.extraProperties);
        substitutions.put("entryPoint", entry);
        substitutions.put("pythonExecutable", extension.getDetails().getSystemPythonInterpreter().getAbsolutePath());
        substitutions.put("toolName", this.project.getName());
        return substitutions;
    }

    @Override
    public void buildEntryPoints() throws Exception {
    }
}

