/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.gradle.python.util.internal.pex;

import com.linkedin.gradle.python.PythonExtension;
import com.linkedin.gradle.python.extension.DeployableExtension;
import com.linkedin.gradle.python.extension.PexExtension;
import com.linkedin.gradle.python.util.EntryPointHelpers;
import com.linkedin.gradle.python.util.ExtensionUtils;
import com.linkedin.gradle.python.util.PexFileUtil;
import com.linkedin.gradle.python.util.entrypoint.EntryPointWriter;
import com.linkedin.gradle.python.util.internal.pex.PexExecOutputParser;
import com.linkedin.gradle.python.util.internal.pex.PexExecSpecAction;
import com.linkedin.gradle.python.util.internal.zipapp.DefaultTemplateProviderOptions;
import com.linkedin.gradle.python.util.internal.zipapp.ThinZipappGenerator;
import com.linkedin.gradle.python.util.pip.PipFreezeAction;
import com.linkedin.gradle.python.util.zipapp.EntryPointTemplateProvider;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.logging.Logging;
import org.gradle.process.ExecResult;

public class ThinPexGenerator
extends ThinZipappGenerator {
    public ThinPexGenerator(Project project, List<String> pexOptions, EntryPointTemplateProvider templateProvider, Map<String, String> extraProperties) {
        super(project, pexOptions, templateProvider, extraProperties);
        logger = Logging.getLogger(ThinPexGenerator.class);
    }

    @Override
    public Map<String, String> buildSubstitutions(PythonExtension extension, String entry) {
        Map<String, String> substitutions = super.buildSubstitutions(extension, entry);
        substitutions.put("realPex", PexFileUtil.createThinPexFilename(this.project.getName()));
        return substitutions;
    }

    @Override
    public void buildEntryPoints() throws Exception {
        PythonExtension extension = ExtensionUtils.getPythonExtension(this.project);
        PexExtension pexExtension = ExtensionUtils.getPythonComponentExtension(extension, PexExtension.class);
        DeployableExtension deployableExtension = ExtensionUtils.getPythonComponentExtension(extension, DeployableExtension.class);
        Map<String, String> dependencies = new PipFreezeAction(this.project).getDependencies();
        PexExecSpecAction action = PexExecSpecAction.withOutEntryPoint(this.project, this.project.getName(), this.options, dependencies);
        ExecResult exec = this.project.exec((Action)action);
        new PexExecOutputParser(action, exec).validatePexBuildSuccessfully();
        for (String it : EntryPointHelpers.collectEntryPoints(this.project)) {
            logger.lifecycle("Processing entry point: {}", new Object[]{it});
            String[] split = it.split("=");
            String name = split[0].trim();
            String entry = split[1].trim();
            Map<String, String> substitutions = this.buildSubstitutions(extension, entry);
            DefaultTemplateProviderOptions providerOptions = new DefaultTemplateProviderOptions(this.project, extension, entry);
            new EntryPointWriter(this.project, this.templateProvider.retrieveTemplate(providerOptions, pexExtension.isPythonWrapper())).writeEntryPoint(new File(deployableExtension.getDeployableBinDir(), name), substitutions);
        }
    }
}

