/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.gradle.python.util.internal;

import java.util.HashMap;
import java.util.Map;

public class TaskTimer {
    private Map<String, Long> timingResults = new HashMap<String, Long>();

    public TickingClock start(String name) {
        return new TickingClock(name, System.currentTimeMillis());
    }

    public String buildReport() {
        StringBuilder sb = new StringBuilder();
        this.timingResults.forEach((key, value) -> sb.append((String)key).append(":\t").append(value).append("\n"));
        return sb.toString();
    }

    public class TickingClock {
        private final String name;
        private final long startedAt;

        TickingClock(String name, long startedAt) {
            this.name = name;
            this.startedAt = startedAt;
        }

        public void stop() {
            TaskTimer.this.timingResults.put(this.name, System.currentTimeMillis() - this.startedAt);
        }
    }
}

